import requests
import json
import configparser

class AcsRequest:

    def __init__(self, config_file='config.ini'):
        self.config = configparser.ConfigParser()
        self.config.read(config_file)

    def send_request(self, payload):
        host = self.config.get('config', 'ACS_HOST')
        port = self.config.get('config', 'ACS_PORT')
        device_id = self.config.get('config', 'DEVICE_ID')

        url = f"http://{host}:{port}/devices/{device_id}/tasks?connection_request"
        headers = {'Content-type': 'application/json', 'Accept': 'text/plain'}
        response = requests.post(url, data=json.dumps(payload), headers=headers, timeout=10)

        # Use this for debugging
        # print("Response status code:", response.status_code)
        # print("Response content:", response.text)
        return response

    def get_value_from_task(self):
        host = self.config.get('config', 'ACS_HOST')
        port = self.config.get('config', 'ACS_PORT')
        device_id = self.config.get('config', 'DEVICE_ID')
        url = f"http://{host}:{port}/devices/?query=%7B%22_id%22%3A%22{device_id}%22%7D"
        headers = {'Content-type': 'application/json', 'Accept': 'text/plain'}
        response = requests.get(url, headers=headers, timeout=10)

        # Use this for debugging
        # print("Response status code:", response.status_code)
        # print("Response content:", response.text)
        return response

