#!/bin/bash
# Author songrq@raisecom.com
#
# Parameters:
#
# Description:
#
# Versions:
# v1.4.17 2020-10-30 create

ipv4_expr='^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$'
port_expr='^([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$'

# Check input parameters.
host=
while [ -z "$checkIp" ] && [ "$host" != "localhost" ]
do
    read -p "Input host(IPv4): " host
    checkIp=`echo $host | egrep $ipv4_expr`
done

read -p "Input node-id of device: " nodeId
read -p "Input name of YANG model: " yangName

schemas=`curl -s http://admin:admin@$host:8181/restconf/operational/network-topology:network-topology/topology/topology-netconf/node/$nodeId/yang-ext:mount/ietf-netconf-monitoring:netconf-state/schemas | grep -Po '"identifier":".*?"|"version":".*?"|"format":".*?"' | tr -d '\n' | sed 's/"identifier/\n"identifier/g' | grep $yangName`

mkdir -p yang
for schema in $schemas
do
    identifier=`echo $schema | grep -Po '(?<=identifier":")[^"]*'`
    version=`echo $schema | grep -Po '(?<=version":")[^"]*'`
    format=`echo $schema | grep -Po '(?<=format":")[^"]*'`
    filename=yang/${identifier}@${version}.yang
    curl -s -X POST http://admin:admin@$host:8181/restconf/operations/network-topology:network-topology/topology/topology-netconf/node/$nodeId/yang-ext:mount/ietf-netconf-monitoring:get-schema -H 'Content-type:application/json' -d "{\"input\":{\"identifier\":\"$identifier\",\"version\":\"$version\",\"format\":\"$format\"}}" | sed 's/\\n/\n/g' | sed 's/\\"/"/g'| sed 's/\\t/\t/g' > $filename
    sed -i '1s/{"output.*:"module/module/g' $filename
    sed -i '$s/"}}$//g' $filename
    echo "Generate $filename"
done

##express2='^\((.+)\?revision=(.+)\)(.+)$'
##capability=(http://www.raisecom.com/yang/vpn/l2tp/raisecom-l2tp-client?revision=2018-09-05)raisecom-l2tp-client
##echo $capability | egrep $express

exit 0
