#!/bin/bash
# Author songruiqi@raisecom.com
#
# Description:
# Find all offline devices caused by no route to host.
#
# Parameters:
# $1 filename, offline devices
#
# Versions:
# v1.4.17 2020-11-18 create

inputFile=$1
until [ ! -z $inputFile ] && [ -f $inputFile ]
do
    read -p "Input filename of offline devices: " inputFile
done

outputFile=logs/ping_fail.log
rm -f $outputFile
cat $inputFile | grep -Po '(?<=:host":")[^"]*' | while read ip
do
    ping -c 1 $ip > /dev/null || echo $ip >> $outputFile
done

exit 0

