#!/bin/bash
# Author songrq@raisecom.com
#
# Parameters:
# $1 filename of callhome ssh-key.
#
# Description:
# Backup callhome ssh-key from configuration datastore of $host.
#
# Versions:
# v1.4.17 2020-10-22 create
# v1.4.19 2020-12-03 support localhost

ipv4_expr='^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$'
port_expr='^([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$'

host=$1
checkIp=`echo $host | egrep $ipv4_expr`
until [ -n "$checkIp" -o "$host" == "localhost" ]
do
    read -p "Input IPv4 address of host: " host
    checkIp=`echo $host | egrep $ipv4_expr`
done

mkdir -p logs
output=logs/callhome.log
curl -s http://admin:admin@$host:8181/restconf/config/odl-netconf-callhome-server:netconf-callhome-server/allowed-devices/ | sed 's/[,]*{"unique-id/\n{"unique-id/g' > $output
sed -i '1d' $output
count=`wc -l $output | awk '{print $1}'`
[ "$count" -ne 0 ] && sed -i "$count,\$ s#\]\}\}\$##g" $output

#cat $output | while read line
#do
#    id=`echo $line | grep -Po '(?<="unique-id":")[^"]*'`
#    curl -s -X PUT http://admin:admin@localhost:8181/restconf/config/odl-netconf-callhome-server:netconf-callhome-server/allowed-devices/device/$id -H "Content-type:application/json" -d "{\"device\":$line}"
#done

echo Finished.

exit 0
