/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.store;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.mdsal.dom.spi.store.AbstractDOMStoreTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.SnapshotBackedTransaction;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class SnapshotBackedReadTransaction<T>
extends AbstractDOMStoreTransaction<T>
implements DOMStoreReadTransaction,
SnapshotBackedTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotBackedReadTransaction.class);
    private volatile DataTreeSnapshot stableSnapshot;

    SnapshotBackedReadTransaction(T identifier, boolean debug, DataTreeSnapshot snapshot) {
        super(identifier, debug);
        this.stableSnapshot = Objects.requireNonNull(snapshot);
        LOG.debug("ReadOnly Tx: {} allocated with snapshot {}", identifier, (Object)snapshot);
    }

    @Override
    public void close() {
        LOG.debug("Store transaction: {} : Closed", this.getIdentifier());
        this.stableSnapshot = null;
    }

    @Override
    public FluentFuture<Optional<NormalizedNode<?, ?>>> read(YangInstanceIdentifier path) {
        LOG.debug("Tx: {} Read: {}", this.getIdentifier(), (Object)path);
        Objects.requireNonNull(path, "Path must not be null.");
        DataTreeSnapshot snapshot = this.stableSnapshot;
        if (snapshot == null) {
            return FluentFutures.immediateFailedFluentFuture((Throwable)new ReadFailedException("Transaction is closed", new RpcError[0]));
        }
        try {
            return FluentFutures.immediateFluentFuture((Object)snapshot.readNode(path));
        }
        catch (Exception e) {
            LOG.error("Tx: {} Failed Read of {}", new Object[]{this.getIdentifier(), path, e});
            return FluentFutures.immediateFailedFluentFuture((Throwable)new ReadFailedException("Read failed", (Throwable)e, new RpcError[0]));
        }
    }

    @Override
    public FluentFuture<Boolean> exists(YangInstanceIdentifier path) {
        LOG.debug("Tx: {} Exists: {}", this.getIdentifier(), (Object)path);
        Objects.requireNonNull(path, "Path must not be null.");
        return this.read(path).transform(Optional::isPresent, MoreExecutors.directExecutor());
    }

    @Override
    public Optional<DataTreeSnapshot> getSnapshot() {
        return Optional.ofNullable(this.stableSnapshot);
    }
}

