/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.store;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransaction;

@Beta
@NonNullByDefault
public abstract class AbstractDOMStoreTransaction<T>
implements DOMStoreTransaction {
    private final @Nullable Throwable debugContext;
    private final T identifier;

    protected AbstractDOMStoreTransaction(T identifier) {
        this(identifier, false);
    }

    @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"})
    protected AbstractDOMStoreTransaction(T identifier, boolean debug) {
        this.identifier = Objects.requireNonNull(identifier, "Identifier must not be null.");
        this.debugContext = debug ? new Throwable().fillInStackTrace() : null;
    }

    public final T getIdentifier() {
        return this.identifier;
    }

    public final @Nullable Throwable getDebugContext() {
        return this.debugContext;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("id", this.identifier);
    }
}

