/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.shard;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListener;
import org.opendaylight.mdsal.dom.spi.shard.AbstractStateAggregator;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.CheckedBuilder;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
final class DOMDataTreeChangeListenerAggregator
extends AbstractStateAggregator<State> {
    private static final Logger LOG = LoggerFactory.getLogger(DOMDataTreeChangeListenerAggregator.class);
    private final boolean allowRxMerges;

    DOMDataTreeChangeListenerAggregator(int sizeHint, boolean allowRxMerges) {
        super(sizeHint);
        this.allowRxMerges = allowRxMerges;
    }

    DOMDataTreeChangeListener createListener(DOMDataTreeIdentifier treeId) {
        StateBuilder builder = new StateBuilder(treeId);
        this.addBuilder(builder);
        return changes -> this.receiveState(builder, new State(treeId, (List<DataTreeCandidate>)ImmutableList.copyOf((Collection)changes)));
    }

    <L extends DOMDataTreeListener> ListenerRegistration<L> start(L listener, final Collection<ListenerRegistration<?>> regs) {
        this.start(builders -> {
            Operational ret = new Operational((Collection<AbstractStateAggregator.StateBuilder<State>>)builders, listener);
            ret.notifyListener(Iterators.transform(builders.iterator(), CheckedBuilder::build));
            return ret;
        });
        return new AbstractListenerRegistration<L>(listener){

            protected void removeRegistration() {
                regs.forEach(ListenerRegistration::close);
            }
        };
    }

    private static final class Operational
    extends AbstractStateAggregator.Operational<State> {
        private final Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>> subtrees = new HashMap();
        private final DOMDataTreeListener listener;

        Operational(Collection<AbstractStateAggregator.StateBuilder<State>> builders, DOMDataTreeListener listener) {
            super(builders);
            this.listener = Objects.requireNonNull(listener);
        }

        @Override
        protected void notifyListener(Iterator<State> iterator) {
            Stopwatch clock = Stopwatch.createStarted();
            ArrayList<DataTreeCandidate> changes = new ArrayList<DataTreeCandidate>();
            while (iterator.hasNext()) {
                State state = iterator.next();
                List<DataTreeCandidate> candidates = state.changes;
                if (candidates.isEmpty()) continue;
                DataTreeCandidateNode lastRoot = candidates.get(candidates.size() - 1).getRootNode();
                Optional optData = lastRoot.getDataAfter();
                if (optData.isPresent()) {
                    this.subtrees.put(state.getIdentifier(), (NormalizedNode<?, ?>)optData.get());
                } else {
                    this.subtrees.remove(state.getIdentifier());
                }
                changes.addAll(candidates);
            }
            int size = changes.size();
            if (size != 0) {
                this.listener.onDataTreeChanged(changes, (Map)ImmutableMap.copyOf(this.subtrees));
                LOG.trace("Listener {} processed {} changes in {}", new Object[]{this.listener, size, clock});
            }
        }
    }

    private static final class StateBuilder
    extends AbstractStateAggregator.StateBuilder<State> {
        @GuardedBy(value="this")
        private final List<DataTreeCandidate> changes = new ArrayList<DataTreeCandidate>();
        private final DOMDataTreeIdentifier identifier;

        StateBuilder(DOMDataTreeIdentifier identifier) {
            this.identifier = Objects.requireNonNull(identifier);
        }

        @Override
        protected synchronized void append(State state) {
            this.changes.addAll(state.changes);
        }

        @Override
        protected synchronized void appendInitial(State state) {
            DataTreeCandidate last = (DataTreeCandidate)Iterables.getLast(state.changes);
            this.changes.clear();
            Optional lastData = last.getRootNode().getDataAfter();
            if (lastData.isPresent()) {
                this.changes.add(DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)last.getRootPath(), (NormalizedNode)((NormalizedNode)lastData.get())));
            }
        }

        public synchronized State build() {
            State ret = new State(this.identifier, (List<DataTreeCandidate>)ImmutableList.copyOf(this.changes));
            this.changes.clear();
            return ret;
        }
    }

    static final class State
    extends AbstractStateAggregator.State
    implements Identifiable<DOMDataTreeIdentifier> {
        private final DOMDataTreeIdentifier identifier;
        final List<DataTreeCandidate> changes;

        State(DOMDataTreeIdentifier identifier, List<DataTreeCandidate> changes) {
            this.identifier = Objects.requireNonNull(identifier);
            this.changes = Objects.requireNonNull(changes);
        }

        public DOMDataTreeIdentifier getIdentifier() {
            return this.identifier;
        }
    }
}

