/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class SimpleDOMMountPoint
implements DOMMountPoint {
    private final YangInstanceIdentifier identifier;
    private final ClassToInstanceMap<DOMService> services;
    private final SchemaContext schemaContext;

    private SimpleDOMMountPoint(YangInstanceIdentifier identifier, ClassToInstanceMap<DOMService> services, SchemaContext ctx) {
        this.identifier = identifier;
        this.services = ImmutableClassToInstanceMap.copyOf(services);
        this.schemaContext = ctx;
    }

    public static SimpleDOMMountPoint create(YangInstanceIdentifier identifier, ClassToInstanceMap<DOMService> services, SchemaContext ctx) {
        return new SimpleDOMMountPoint(identifier, services, ctx);
    }

    public YangInstanceIdentifier getIdentifier() {
        return this.identifier;
    }

    public SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public <T extends DOMService> Optional<T> getService(Class<T> cls) {
        return Optional.ofNullable(this.services.getInstance(cls));
    }
}

