/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.annotations.Beta;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.EventListener;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.api.DOMSchemaServiceExtension;
import org.opendaylight.mdsal.dom.api.DOMYangTextSourceProvider;
import org.opendaylight.mdsal.dom.spi.AbstractDOMSchemaService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.NoOpListenerRegistration;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;

@Beta
public class FixedDOMSchemaService
extends AbstractDOMSchemaService {
    private final @NonNull SchemaContextProvider schemaContextProvider;

    private FixedDOMSchemaService(SchemaContextProvider schemaContextProvider) {
        this.schemaContextProvider = Objects.requireNonNull(schemaContextProvider);
    }

    public static @NonNull DOMSchemaService of(SchemaContextProvider schemaContextProvider) {
        return new FixedDOMSchemaService(schemaContextProvider);
    }

    public static @NonNull DOMSchemaService of(SchemaContextProvider schemaContextProvider, SchemaSourceProvider<YangTextSchemaSource> yangTextSourceProvider) {
        return new WithYangTextSources(schemaContextProvider, Objects.requireNonNull(yangTextSourceProvider));
    }

    public final SchemaContext getGlobalContext() {
        return this.schemaContextProvider.getSchemaContext();
    }

    public final @NonNull ListenerRegistration<SchemaContextListener> registerSchemaContextListener(SchemaContextListener listener) {
        listener.onGlobalContextUpdated(this.getGlobalContext());
        return NoOpListenerRegistration.of((EventListener)listener);
    }

    private static final class WithYangTextSources
    extends FixedDOMSchemaService
    implements DOMYangTextSourceProvider {
        private final @NonNull SchemaSourceProvider<YangTextSchemaSource> schemaSourceProvider;

        WithYangTextSources(SchemaContextProvider schemaContextProvider, SchemaSourceProvider<YangTextSchemaSource> schemaSourceProvider) {
            super(schemaContextProvider);
            this.schemaSourceProvider = Objects.requireNonNull(schemaSourceProvider);
        }

        @Override
        public ClassToInstanceMap<DOMSchemaServiceExtension> getExtensions() {
            return ImmutableClassToInstanceMap.of(DOMYangTextSourceProvider.class, (Object)this);
        }

        public ListenableFuture<? extends YangTextSchemaSource> getSource(SourceIdentifier sourceIdentifier) {
            return this.schemaSourceProvider.getSource(sourceIdentifier);
        }
    }
}

