/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.messagebus.eventsources.netconf;

import com.google.common.util.concurrent.FluentFuture;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.messagebus.eventsources.netconf.NetconfEventSource;
import org.opendaylight.netconf.messagebus.eventsources.netconf.NetconfEventSourceMount;
import org.opendaylight.netconf.messagebus.eventsources.netconf.NotificationTopicRegistration;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamNotificationTopicRegistration
extends NotificationTopicRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(StreamNotificationTopicRegistration.class);
    private final String nodeId;
    private final NetconfEventSource netconfEventSource;
    private final NetconfEventSourceMount mountPoint;
    private final ConcurrentHashMap<SchemaPath, ListenerRegistration<DOMNotificationListener>> notificationRegistrationMap = new ConcurrentHashMap();
    private final Stream stream;

    StreamNotificationTopicRegistration(Stream stream, String notificationPrefix, NetconfEventSource netconfEventSource) {
        super(NotificationTopicRegistration.NotificationSourceType.NetconfDeviceStream, stream.getName().getValue(), notificationPrefix);
        this.netconfEventSource = netconfEventSource;
        this.mountPoint = netconfEventSource.getMount();
        this.nodeId = this.mountPoint.getNode().getNodeId().getValue();
        this.stream = stream;
        this.setReplaySupported(stream.isReplaySupport());
        this.setActive(false);
        LOG.info("StreamNotificationTopicRegistration initialized for {}", (Object)this.getStreamName());
    }

    @Override
    void activateNotificationSource() {
        if (!this.isActive()) {
            LOG.info("Stream {} is not active on node {}. Will subscribe.", (Object)this.getStreamName(), (Object)this.nodeId);
            FluentFuture<DOMRpcResult> result = this.mountPoint.invokeCreateSubscription(this.stream);
            try {
                result.get();
                this.setActive(true);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Can not subscribe stream {} on node {}", new Object[]{this.getSourceName(), this.nodeId, e});
                this.setActive(false);
            }
        } else {
            LOG.info("Stream {} is now active on node {}", (Object)this.getStreamName(), (Object)this.nodeId);
        }
    }

    @Override
    void reActivateNotificationSource() {
        if (this.isActive()) {
            LOG.info("Stream {} is reactivating on node {}.", (Object)this.getStreamName(), (Object)this.nodeId);
            FluentFuture<DOMRpcResult> result = this.mountPoint.invokeCreateSubscription(this.stream, this.getLastEventTime());
            try {
                result.get();
                this.setActive(true);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Can not resubscribe stream {} on node {}", new Object[]{this.getSourceName(), this.nodeId, e});
                this.setActive(false);
            }
        }
    }

    @Override
    void deActivateNotificationSource() {
    }

    private void closeStream() {
        if (this.isActive()) {
            for (ListenerRegistration<DOMNotificationListener> reg : this.notificationRegistrationMap.values()) {
                reg.close();
            }
            this.notificationRegistrationMap.clear();
            this.notificationTopicMap.clear();
            this.setActive(false);
        }
    }

    private String getStreamName() {
        return this.getSourceName();
    }

    @Override
    boolean registerNotificationTopic(SchemaPath notificationPath, TopicId topicId) {
        if (!this.checkNotificationPath(notificationPath)) {
            LOG.debug("Bad SchemaPath for notification try to register");
            return false;
        }
        this.activateNotificationSource();
        if (!this.isActive()) {
            LOG.warn("Stream {} is not active, listener for notification {} is not registered.", (Object)this.getStreamName(), (Object)notificationPath.toString());
            return false;
        }
        ListenerRegistration<DOMNotificationListener> registration = this.mountPoint.registerNotificationListener(this.netconfEventSource, notificationPath);
        this.notificationRegistrationMap.put(notificationPath, registration);
        Set<TopicId> topicIds = this.getTopicsForNotification(notificationPath);
        topicIds.add(topicId);
        this.notificationTopicMap.put(notificationPath, topicIds);
        return true;
    }

    @Override
    synchronized void unRegisterNotificationTopic(TopicId topicId) {
        ArrayList<SchemaPath> notificationPathToRemove = new ArrayList<SchemaPath>();
        for (SchemaPath notifKey : this.notificationTopicMap.keySet()) {
            Set topicList = (Set)this.notificationTopicMap.get(notifKey);
            if (topicList == null) continue;
            topicList.remove(topicId);
            if (!topicList.isEmpty()) continue;
            notificationPathToRemove.add(notifKey);
        }
        for (SchemaPath notifKey : notificationPathToRemove) {
            this.notificationTopicMap.remove(notifKey);
            ListenerRegistration<DOMNotificationListener> reg = this.notificationRegistrationMap.remove(notifKey);
            if (reg == null) continue;
            reg.close();
        }
    }

    @Override
    public void close() {
        this.closeStream();
    }
}

