/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.messagebus.eventsources.netconf;

import java.time.Instant;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NotificationTopicRegistration
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationTopicRegistration.class);
    private boolean active;
    private final NotificationSourceType notificationSourceType;
    private final String sourceName;
    private final String notificationUrnPrefix;
    private boolean replaySupported;
    private Instant lastEventTime;
    protected final ConcurrentHashMap<SchemaPath, Set<TopicId>> notificationTopicMap = new ConcurrentHashMap();

    protected NotificationTopicRegistration(NotificationSourceType notificationSourceType, String sourceName, String notificationUrnPrefix) {
        this.notificationSourceType = notificationSourceType;
        this.sourceName = sourceName;
        this.notificationUrnPrefix = notificationUrnPrefix;
        this.active = false;
        this.setReplaySupported(false);
    }

    public boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        this.active = active;
    }

    public NotificationSourceType getNotificationSourceType() {
        return this.notificationSourceType;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getNotificationUrnPrefix() {
        return this.notificationUrnPrefix;
    }

    Set<TopicId> getTopicsForNotification(SchemaPath notificationPath) {
        HashSet topicIds = this.notificationTopicMap.get(notificationPath);
        return topicIds != null ? topicIds : new HashSet();
    }

    boolean checkNotificationPath(SchemaPath notificationPath) {
        if (notificationPath == null) {
            return false;
        }
        String nameSpace = notificationPath.getLastComponent().getNamespace().toString();
        LOG.debug("CheckNotification - name space {} - NotificationUrnPrefix {}", (Object)nameSpace, (Object)this.getNotificationUrnPrefix());
        return nameSpace.startsWith(this.getNotificationUrnPrefix());
    }

    Optional<Instant> getLastEventTime() {
        return Optional.ofNullable(this.lastEventTime);
    }

    void setLastEventTime(Instant lastEventTime) {
        this.lastEventTime = lastEventTime;
    }

    abstract void activateNotificationSource();

    abstract void deActivateNotificationSource();

    abstract void reActivateNotificationSource();

    abstract boolean registerNotificationTopic(SchemaPath var1, TopicId var2);

    abstract void unRegisterNotificationTopic(TopicId var1);

    public boolean isReplaySupported() {
        return this.replaySupported;
    }

    protected void setReplaySupported(boolean replaySupported) {
        this.replaySupported = replaySupported;
    }

    public static enum NotificationSourceType {
        NetconfDeviceStream,
        ConnectionStatusChange;

    }
}

