/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.messagebus.eventsources.netconf;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import org.opendaylight.controller.messagebus.spi.EventSource;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistration;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.netconf.messagebus.eventsources.netconf.NetconfEventSource;
import org.opendaylight.netconf.messagebus.eventsources.netconf.NetconfEventSourceManager;
import org.opendaylight.netconf.messagebus.eventsources.netconf.NetconfEventSourceMount;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeConnectionStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.available.capabilities.AvailableCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.network.topology.topology.topology.types.TopologyNetconf;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfEventSourceRegistration
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfEventSourceRegistration.class);
    private static final YangInstanceIdentifier NETCONF_DEVICE_DOM_PATH = YangInstanceIdentifier.builder().node(NetworkTopology.QNAME).node(Topology.QNAME).nodeWithKey(Topology.QNAME, QName.create((QName)Topology.QNAME, (String)"topology-id"), (Object)TopologyNetconf.QNAME.getLocalName()).node(Node.QNAME).build();
    private static final QName NODE_ID_QNAME = QName.create((QName)Node.QNAME, (String)"node-id");
    private static final String NOTIFICATION_CAPABILITY_PREFIX = "(urn:ietf:params:xml:ns:netconf:notification";
    private final Node node;
    private final NetconfEventSourceManager netconfEventSourceManager;
    private NetconfNodeConnectionStatus.ConnectionStatus currentNetconfConnStatus;
    private EventSourceRegistration<NetconfEventSource> eventSourceRegistration;

    public static NetconfEventSourceRegistration create(InstanceIdentifier<?> instanceIdent, Node node, NetconfEventSourceManager netconfEventSourceManager) {
        Preconditions.checkNotNull(instanceIdent);
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)netconfEventSourceManager);
        if (!NetconfEventSourceRegistration.isEventSource(node)) {
            return null;
        }
        NetconfEventSourceRegistration nesr = new NetconfEventSourceRegistration(node, netconfEventSourceManager);
        nesr.updateStatus();
        LOG.debug("NetconfEventSourceRegistration for node {} has been initialized...", (Object)node.getNodeId().getValue());
        return nesr;
    }

    private static boolean isEventSource(Node node) {
        NetconfNode netconfNode = (NetconfNode)node.augmentation(NetconfNode.class);
        if (netconfNode == null) {
            return false;
        }
        if (netconfNode.getAvailableCapabilities() == null) {
            return false;
        }
        List capabilities = netconfNode.getAvailableCapabilities().getAvailableCapability();
        if (capabilities == null || capabilities.isEmpty()) {
            return false;
        }
        for (AvailableCapability capability : netconfNode.getAvailableCapabilities().getAvailableCapability()) {
            if (!capability.getCapability().startsWith(NOTIFICATION_CAPABILITY_PREFIX)) continue;
            return true;
        }
        return false;
    }

    private NetconfEventSourceRegistration(Node node, NetconfEventSourceManager netconfEventSourceManager) {
        this.node = node;
        this.netconfEventSourceManager = netconfEventSourceManager;
        this.eventSourceRegistration = null;
        this.currentNetconfConnStatus = NetconfNodeConnectionStatus.ConnectionStatus.Connecting;
    }

    Optional<EventSourceRegistration<NetconfEventSource>> getEventSourceRegistration() {
        return Optional.ofNullable(this.eventSourceRegistration);
    }

    NetconfNode getNetconfNode() {
        return (NetconfNode)this.node.augmentation(NetconfNode.class);
    }

    void updateStatus() {
        NetconfNodeConnectionStatus.ConnectionStatus netconfConnStatus = this.getNetconfNode().getConnectionStatus();
        LOG.info("Change status on node {}, new status is {}", (Object)this.node.getNodeId().getValue(), (Object)netconfConnStatus);
        if (netconfConnStatus.equals((Object)this.currentNetconfConnStatus)) {
            return;
        }
        this.changeStatus(netconfConnStatus);
    }

    private static boolean checkConnectionStatusType(NetconfNodeConnectionStatus.ConnectionStatus status) {
        return status == NetconfNodeConnectionStatus.ConnectionStatus.Connected || status == NetconfNodeConnectionStatus.ConnectionStatus.Connecting || status == NetconfNodeConnectionStatus.ConnectionStatus.UnableToConnect;
    }

    private void changeStatus(NetconfNodeConnectionStatus.ConnectionStatus newStatus) {
        Preconditions.checkNotNull((Object)newStatus);
        Preconditions.checkState((this.currentNetconfConnStatus != null ? 1 : 0) != 0);
        if (!NetconfEventSourceRegistration.checkConnectionStatusType(newStatus)) {
            throw new IllegalStateException("Unknown new Netconf Connection Status");
        }
        switch (this.currentNetconfConnStatus) {
            case Connecting: 
            case UnableToConnect: {
                if (newStatus != NetconfNodeConnectionStatus.ConnectionStatus.Connected) break;
                if (this.eventSourceRegistration == null) {
                    this.registrationEventSource();
                    break;
                }
                ((NetconfEventSource)this.eventSourceRegistration.getInstance()).reActivateStreams();
                break;
            }
            case Connected: {
                if (newStatus != NetconfNodeConnectionStatus.ConnectionStatus.Connecting && newStatus != NetconfNodeConnectionStatus.ConnectionStatus.UnableToConnect) break;
                ((NetconfEventSource)this.eventSourceRegistration.getInstance()).deActivateStreams();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown current Netconf Connection Status");
            }
        }
        this.currentNetconfConnStatus = newStatus;
    }

    private void registrationEventSource() {
        Optional domMountPoint = this.netconfEventSourceManager.getDomMounts().getMountPoint(NetconfEventSourceRegistration.domMountPath(this.node.getNodeId()));
        EventSourceRegistration registration = null;
        if (domMountPoint.isPresent()) {
            NetconfEventSourceMount mount = new NetconfEventSourceMount(this.node, (DOMMountPoint)domMountPoint.get());
            NetconfEventSource netconfEventSource = new NetconfEventSource(this.netconfEventSourceManager.getStreamMap(), mount, this.netconfEventSourceManager.getPublishService());
            registration = this.netconfEventSourceManager.getEventSourceRegistry().registerEventSource((EventSource)netconfEventSource);
            LOG.info("Event source {} has been registered", (Object)this.node.getNodeId().getValue());
        }
        this.eventSourceRegistration = registration;
    }

    private static YangInstanceIdentifier domMountPath(NodeId nodeId) {
        return YangInstanceIdentifier.builder((YangInstanceIdentifier)NETCONF_DEVICE_DOM_PATH).nodeWithKey(Node.QNAME, NODE_ID_QNAME, (Object)nodeId.getValue()).build();
    }

    private void closeEventSourceRegistration() {
        if (this.getEventSourceRegistration().isPresent()) {
            this.getEventSourceRegistration().get().close();
        }
    }

    @Override
    public void close() {
        this.closeEventSourceRegistration();
    }
}

