/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.messagebus.eventsources.netconf;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.controller.messagebus.app.util.TopicDOMNotification;
import org.opendaylight.controller.messagebus.app.util.Util;
import org.opendaylight.controller.messagebus.spi.EventSource;
import org.opendaylight.mdsal.dom.api.DOMEvent;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishService;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.messagebus.eventsources.netconf.ConnectionNotificationTopicRegistration;
import org.opendaylight.netconf.messagebus.eventsources.netconf.NetconfEventSourceMount;
import org.opendaylight.netconf.messagebus.eventsources.netconf.NotificationTopicRegistration;
import org.opendaylight.netconf.messagebus.eventsources.netconf.StreamNotificationTopicRegistration;
import org.opendaylight.netconf.util.NetconfUtil;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.NotificationPattern;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicNotification;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.DisJoinTopicInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.DisJoinTopicOutput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.DisJoinTopicOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicOutput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicStatus;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NetconfEventSource
implements EventSource,
DOMNotificationListener {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfEventSource.class);
    private static final YangInstanceIdentifier.NodeIdentifier TOPIC_NOTIFICATION_ARG = YangInstanceIdentifier.NodeIdentifier.create((QName)TopicNotification.QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier EVENT_SOURCE_ARG = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)TopicNotification.QNAME, (String)"node-id"));
    private static final YangInstanceIdentifier.NodeIdentifier TOPIC_ID_ARG = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)TopicNotification.QNAME, (String)"topic-id"));
    private static final YangInstanceIdentifier.NodeIdentifier PAYLOAD_ARG = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)TopicNotification.QNAME, (String)"payload"));
    private static final String CONNECTION_NOTIFICATION_SOURCE_NAME = "ConnectionNotificationSource";
    private final DOMNotificationPublishService domPublish;
    private final Map<String, String> urnPrefixToStreamMap;
    private final Multimap<String, NotificationTopicRegistration> notificationTopicRegistrations = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private final NetconfEventSourceMount mount;

    public NetconfEventSource(Map<String, String> streamMap, NetconfEventSourceMount mount, DOMNotificationPublishService publishService) {
        this.mount = mount;
        this.urnPrefixToStreamMap = (Map)Preconditions.checkNotNull(streamMap);
        this.domPublish = (DOMNotificationPublishService)Preconditions.checkNotNull((Object)publishService);
        this.initializeNotificationTopicRegistrationList();
        LOG.info("NetconfEventSource [{}] created.", (Object)mount.getNodeId());
    }

    private void initializeNotificationTopicRegistrationList() {
        ConnectionNotificationTopicRegistration cntr = new ConnectionNotificationTopicRegistration(CONNECTION_NOTIFICATION_SOURCE_NAME, this);
        this.notificationTopicRegistrations.put((Object)cntr.getNotificationUrnPrefix(), (Object)cntr);
        Map<String, Stream> availableStreams = this.getAvailableStreams();
        LOG.debug("Stream configuration compare...");
        for (Map.Entry<String, String> entry : this.urnPrefixToStreamMap.entrySet()) {
            String urnPrefix = entry.getKey();
            String streamName = entry.getValue();
            LOG.debug("urnPrefix: {} streamName: {}", (Object)urnPrefix, (Object)streamName);
            if (!availableStreams.containsKey(streamName)) continue;
            LOG.debug("Stream containig on device");
            this.notificationTopicRegistrations.put((Object)urnPrefix, (Object)new StreamNotificationTopicRegistration(availableStreams.get(streamName), urnPrefix, this));
        }
    }

    private Map<String, Stream> getAvailableStreams() {
        ImmutableMap streamMap = new HashMap();
        try {
            List<Stream> availableStreams = this.mount.getAvailableStreams();
            streamMap = Maps.uniqueIndex(availableStreams, input -> input.getName().getValue());
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Can not read streams for node {}", (Object)this.mount.getNodeId(), (Object)e);
        }
        return streamMap;
    }

    public ListenableFuture<RpcResult<JoinTopicOutput>> joinTopic(JoinTopicInput input) {
        LOG.debug("Join topic {} on {}", (Object)input.getTopicId().getValue(), (Object)this.mount.getNodeId());
        NotificationPattern notificationPattern = input.getNotificationPattern();
        List<SchemaPath> matchingNotifications = this.getMatchingNotifications(notificationPattern);
        return this.registerTopic(input.getTopicId(), matchingNotifications);
    }

    public ListenableFuture<RpcResult<DisJoinTopicOutput>> disJoinTopic(DisJoinTopicInput input) {
        for (NotificationTopicRegistration reg : this.notificationTopicRegistrations.values()) {
            reg.unRegisterNotificationTopic(input.getTopicId());
        }
        return Util.resultRpcSuccessFor((Object)new DisJoinTopicOutputBuilder().build());
    }

    private synchronized ListenableFuture<RpcResult<JoinTopicOutput>> registerTopic(TopicId topicId, List<SchemaPath> notificationsToSubscribe) {
        Preconditions.checkNotNull(notificationsToSubscribe);
        LOG.debug("Join topic {} - register", (Object)topicId);
        JoinTopicStatus joinTopicStatus = JoinTopicStatus.Down;
        LOG.debug("Notifications to subscribe has found - count {}", (Object)notificationsToSubscribe.size());
        int registeredNotificationCount = 0;
        for (SchemaPath schemaPath : notificationsToSubscribe) {
            Collection topicRegistrations = this.notificationTopicRegistrations.get((Object)schemaPath.getLastComponent().getNamespace().toString());
            for (NotificationTopicRegistration reg : topicRegistrations) {
                LOG.info("Source of notification {} is activating, TopicId {}", (Object)reg.getSourceName(), (Object)topicId.getValue());
                boolean regSuccess = reg.registerNotificationTopic(schemaPath, topicId);
                if (!regSuccess) continue;
                ++registeredNotificationCount;
            }
        }
        if (registeredNotificationCount > 0) {
            joinTopicStatus = JoinTopicStatus.Up;
        }
        JoinTopicOutput output = new JoinTopicOutputBuilder().setStatus(joinTopicStatus).build();
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)output).build());
    }

    public void reActivateStreams() {
        for (NotificationTopicRegistration reg : this.notificationTopicRegistrations.values()) {
            LOG.info("Source of notification {} is reactivating on node {}", (Object)reg.getSourceName(), (Object)this.mount.getNodeId());
            reg.reActivateNotificationSource();
        }
    }

    public void deActivateStreams() {
        for (NotificationTopicRegistration reg : this.notificationTopicRegistrations.values()) {
            LOG.info("Source of notification {} is deactivating on node {}", (Object)reg.getSourceName(), (Object)this.mount.getNodeId());
            reg.deActivateNotificationSource();
        }
    }

    public void onNotification(DOMNotification notification) {
        SchemaPath notificationPath = notification.getType();
        Instant notificationEventTime = null;
        if (notification instanceof DOMEvent) {
            notificationEventTime = ((DOMEvent)notification).getEventInstant();
        }
        String namespace = notification.getType().getLastComponent().getNamespace().toString();
        for (NotificationTopicRegistration notifReg : this.notificationTopicRegistrations.get((Object)namespace)) {
            notifReg.setLastEventTime(notificationEventTime);
            for (TopicId topicId : notifReg.getTopicsForNotification(notificationPath)) {
                this.publishNotification(notification, topicId);
                LOG.debug("Notification {} has been published for TopicId {}", (Object)notification.getType(), (Object)topicId.getValue());
            }
        }
    }

    private void publishNotification(DOMNotification notification, TopicId topicId) {
        ContainerNode topicNotification = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)TOPIC_NOTIFICATION_ARG).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)TOPIC_ID_ARG, (Object)topicId)).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)EVENT_SOURCE_ARG, (Object)this.mount.getNodeId())).withChild((DataContainerChild)this.encapsulate(notification)).build();
        try {
            this.domPublish.putNotification((DOMNotification)new TopicDOMNotification(topicNotification));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private AnyXmlNode encapsulate(DOMNotification body) {
        Document doc = XmlUtil.newDocument();
        Optional<String> namespace = Optional.of(PAYLOAD_ARG.getNodeType().getNamespace().toString());
        Element element = XmlUtil.createElement((Document)doc, (String)"payload", namespace);
        DOMResult result = new DOMResult(element);
        SchemaContext context = this.mount.getSchemaContext();
        SchemaPath schemaPath = body.getType();
        try {
            NetconfUtil.writeNormalizedNode((NormalizedNode)body.getBody(), (DOMResult)result, (SchemaPath)schemaPath, (SchemaContext)context);
            return (AnyXmlNode)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)PAYLOAD_ARG).withValue((Object)new DOMSource(element)).build();
        }
        catch (IOException | XMLStreamException e) {
            LOG.error("Unable to encapsulate notification.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<SchemaPath> getMatchingNotifications(NotificationPattern notificationPattern) {
        String regex = notificationPattern.getValue();
        Pattern pattern = Pattern.compile(regex);
        List<SchemaPath> availableNotifications = this.getAvailableNotifications();
        return Util.expandQname(availableNotifications, (Pattern)pattern);
    }

    public void close() throws Exception {
        for (NotificationTopicRegistration streamReg : this.notificationTopicRegistrations.values()) {
            streamReg.close();
        }
    }

    public NodeKey getSourceNodeKey() {
        return this.mount.getNode().key();
    }

    public List<SchemaPath> getAvailableNotifications() {
        ArrayList<SchemaPath> availNotifList = new ArrayList<SchemaPath>();
        availNotifList.add(ConnectionNotificationTopicRegistration.EVENT_SOURCE_STATUS_PATH);
        Set availableNotifications = this.mount.getSchemaContext().getNotifications();
        for (NotificationDefinition nd : availableNotifications) {
            availNotifList.add(nd.getPath());
        }
        return availNotifList;
    }

    NetconfEventSourceMount getMount() {
        return this.mount;
    }
}

