/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.resolver.obr.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.apache.aries.application.Content;
import org.apache.aries.application.modelling.Consumer;
import org.apache.aries.application.modelling.ImportedBundle;
import org.apache.aries.application.resolver.obr.impl.RequirementImpl;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class ApplicationResourceImpl
implements Resource {
    private String _symbolicName;
    private Version _version;
    private List<Requirement> _requirements = new ArrayList<Requirement>();

    public ApplicationResourceImpl(String appName, Version appVersion, List<Content> appContent) {
        this._symbolicName = appName;
        this._version = appVersion;
        for (int i = 0; i < appContent.size(); ++i) {
            Content c = appContent.get(i);
            String comment = "Requires symbolicname " + c.getContentName() + " with attributes " + c.getAttributes();
            String resolution = c.getDirective("resolution");
            boolean optional = Boolean.valueOf(resolution);
            String f = ManifestHeaderProcessor.generateFilter((String)"symbolicname", (String)c.getContentName(), (Map)c.getAttributes());
            try {
                Filter filter = FrameworkUtil.createFilter((String)f);
                this._requirements.add(new RequirementImpl("bundle", new FilterWrapper(filter), false, optional, false, comment));
                continue;
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
        }
    }

    public ApplicationResourceImpl(String appName, Version appVersion, Collection<ImportedBundle> inputs) {
        this._symbolicName = appName;
        this._version = appVersion;
        for (ImportedBundle match : inputs) {
            this._requirements.add(new RequirementImpl((Consumer)match));
        }
    }

    public Capability[] getCapabilities() {
        return null;
    }

    public String[] getCategories() {
        return null;
    }

    public String getId() {
        return this._symbolicName;
    }

    public String getPresentationName() {
        return this._symbolicName;
    }

    public Map getProperties() {
        return null;
    }

    public Requirement[] getRequirements() {
        if (this._requirements != null) {
            Requirement[] reqs = new Requirement[this._requirements.size()];
            int index = 0;
            for (Requirement req : this._requirements) {
                reqs[index++] = req;
            }
            return reqs;
        }
        return null;
    }

    public String getSymbolicName() {
        return this._symbolicName;
    }

    public URL getURL() {
        return null;
    }

    public Version getVersion() {
        return this._version;
    }

    public Long getSize() {
        return 0L;
    }

    public String getURI() {
        return null;
    }

    public boolean isLocal() {
        return false;
    }

    private static class FilterWrapper
    implements Filter {
        private Filter delgate;

        public FilterWrapper(Filter f) {
            this.delgate = f;
        }

        public boolean match(ServiceReference reference) {
            return this.delgate.match(reference);
        }

        public boolean match(Dictionary dictionary) {
            boolean result = this.delgate.match(dictionary);
            return result;
        }

        public boolean matchCase(Dictionary dictionary) {
            return this.delgate.matchCase(dictionary);
        }

        public String toString() {
            return this.delgate.toString();
        }
    }
}

