/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.repo.DependencyResolver;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangModelDependencyInfo;

final class RevisionDependencyResolver
extends DependencyResolver {
    protected RevisionDependencyResolver(Map<SourceIdentifier, YangModelDependencyInfo> depInfo) {
        super(depInfo);
    }

    protected static SourceIdentifier findWildcard(Iterable<SourceIdentifier> haystack, String needle) {
        for (SourceIdentifier r : haystack) {
            if (!needle.equals(r.getName())) continue;
            return r;
        }
        return null;
    }

    @Override
    protected boolean isKnown(Collection<SourceIdentifier> haystack, ModuleImport mi) {
        RevisionSourceIdentifier msi = RevisionSourceIdentifier.create((String)mi.getModuleName(), (Optional)mi.getRevision());
        if (haystack.contains(msi)) {
            return true;
        }
        return !mi.getRevision().isPresent() && RevisionDependencyResolver.findWildcard(haystack, mi.getModuleName()) != null;
    }

    public static RevisionDependencyResolver create(Map<SourceIdentifier, YangModelDependencyInfo> depInfo) {
        return new RevisionDependencyResolver(depInfo);
    }
}

