/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.common.util;

import java.util.Collection;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

public final class RestconfSchemaUtil {
    private RestconfSchemaUtil() {
        throw new UnsupportedOperationException("Util class");
    }

    public static <T extends SchemaNode> T findSchemaNodeInCollection(Collection<T> collection, String schemaNodeName) {
        for (SchemaNode child : collection) {
            if (!child.getQName().getLocalName().equals(schemaNodeName)) continue;
            return (T)child;
        }
        throw new RestconfDocumentedException("Schema node " + schemaNodeName + " does not exist in module.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.DATA_MISSING);
    }
}

