/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IdentityValuesDTO {
    private final List<IdentityValue> elementData = new ArrayList<IdentityValue>();
    private final String originValue;

    public IdentityValuesDTO(String namespace, String value, String prefix, String originValue) {
        this.elementData.add(new IdentityValue(namespace, value));
        this.originValue = originValue;
    }

    public IdentityValuesDTO(String originValue) {
        this.originValue = originValue;
    }

    public IdentityValuesDTO() {
        this.originValue = null;
    }

    public void add(String namespace, String value, String prefix) {
        this.elementData.add(new IdentityValue(namespace, value));
    }

    public void add(IdentityValue identityValue) {
        this.elementData.add(identityValue);
    }

    public List<IdentityValue> getValuesWithNamespaces() {
        return Collections.unmodifiableList(this.elementData);
    }

    public String toString() {
        return this.elementData.toString();
    }

    public String getOriginValue() {
        return this.originValue;
    }

    public static final class Predicate {
        private final IdentityValue name;
        private final String value;

        public Predicate(IdentityValue name, String value) {
            this.name = name;
            this.value = value;
        }

        public IdentityValue getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.name != null) {
                sb.append(this.name.toString());
            }
            if (this.value != null) {
                sb.append("=").append(this.value);
            }
            return sb.toString();
        }

        public boolean isLeafList() {
            return this.name == null;
        }
    }

    public static final class IdentityValue {
        private final String namespace;
        private final String value;
        private List<Predicate> predicates;

        public IdentityValue(String namespace, String value) {
            this.namespace = namespace;
            this.value = value;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getValue() {
            return this.value;
        }

        public List<Predicate> getPredicates() {
            if (this.predicates == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.predicates);
        }

        public void setPredicates(List<Predicate> predicates) {
            this.predicates = predicates;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.namespace != null) {
                sb.append(this.namespace);
            }
            if (this.value != null) {
                sb.append(" - ").append(this.value);
            }
            if (this.predicates != null && !this.predicates.isEmpty()) {
                for (Predicate predicate : this.predicates) {
                    sb.append("[").append(predicate.toString()).append("]");
                }
            }
            return sb.toString();
        }
    }
}

