/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.common.errors;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Locale;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class RestconfError
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ErrorType errorType;
    private final ErrorTag errorTag;
    private final String errorInfo;
    private final String errorAppTag;
    private final String errorMessage;
    private final YangInstanceIdentifier errorPath;

    public RestconfError(ErrorType errorType, ErrorTag errorTag, String errorMessage) {
        this(errorType, errorTag, errorMessage, null, null, null);
    }

    public RestconfError(ErrorType errorType, ErrorTag errorTag, String errorMessage, String errorAppTag) {
        this(errorType, errorTag, errorMessage, errorAppTag, null, null);
    }

    public RestconfError(ErrorType errorType, ErrorTag errorTag, String errorMessage, YangInstanceIdentifier errorPath) {
        this(errorType, errorTag, errorMessage, null, null, errorPath);
    }

    public RestconfError(ErrorType errorType, ErrorTag errorTag, String errorMessage, String errorAppTag, String errorInfo) {
        this(errorType, errorTag, errorMessage, errorAppTag, errorInfo, null);
    }

    public RestconfError(ErrorType errorType, ErrorTag errorTag, String errorMessage, String errorAppTag, String errorInfo, YangInstanceIdentifier errorPath) {
        Preconditions.checkNotNull((Object)((Object)errorType), (Object)"Error type is required for RestConfError");
        Preconditions.checkNotNull((Object)((Object)errorTag), (Object)"Error tag is required for RestConfError");
        this.errorType = errorType;
        this.errorTag = errorTag;
        this.errorMessage = errorMessage;
        this.errorAppTag = errorAppTag;
        this.errorInfo = errorInfo;
        this.errorPath = errorPath;
    }

    public RestconfError(RpcError rpcError) {
        this.errorType = rpcError.getErrorType() == null ? ErrorType.APPLICATION : ErrorType.valueOfCaseInsensitive(rpcError.getErrorType().name());
        this.errorTag = rpcError.getTag() == null ? ErrorTag.OPERATION_FAILED : ErrorTag.valueOfCaseInsensitive(rpcError.getTag());
        this.errorMessage = rpcError.getMessage();
        this.errorAppTag = rpcError.getApplicationTag();
        String localErrorInfo = null;
        if (rpcError.getInfo() == null) {
            if (rpcError.getCause() != null) {
                localErrorInfo = rpcError.getCause().getMessage();
            } else if (rpcError.getSeverity() != null) {
                localErrorInfo = "<severity>" + rpcError.getSeverity().toString().toLowerCase(Locale.ROOT) + "</severity>";
            }
        } else {
            localErrorInfo = rpcError.getInfo();
        }
        this.errorInfo = localErrorInfo;
        this.errorPath = null;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public ErrorTag getErrorTag() {
        return this.errorTag;
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    public String getErrorAppTag() {
        return this.errorAppTag;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public YangInstanceIdentifier getErrorPath() {
        return this.errorPath;
    }

    public String toString() {
        return "RestconfError [error-type: " + this.errorType.getErrorTypeTag() + ", error-tag: " + this.errorTag.getTagValue() + (this.errorAppTag != null ? ", error-app-tag: " + this.errorAppTag : "") + (this.errorMessage != null ? ", error-message: " + this.errorMessage : "") + (this.errorInfo != null ? ", error-info: " + this.errorInfo : "") + (this.errorPath != null ? ", error-path: " + this.errorPath.toString() : "") + "]";
    }

    public static enum ErrorTag {
        IN_USE("in-use", 409),
        INVALID_VALUE("invalid-value", 400),
        TOO_BIG("too-big", 413),
        MISSING_ATTRIBUTE("missing-attribute", 400),
        BAD_ATTRIBUTE("bad-attribute", 400),
        UNKNOWN_ATTRIBUTE("unknown-attribute", 400),
        MISSING_ELEMENT("missing-element", 400),
        BAD_ELEMENT("bad-element", 400),
        UNKNOWN_ELEMENT("unknown-element", 400),
        UNKNOWN_NAMESPACE("unknown-namespace", 400),
        ACCESS_DENIED("access-denied", 403),
        LOCK_DENIED("lock-denied", 409),
        RESOURCE_DENIED("resource-denied", 409),
        ROLLBACK_FAILED("rollback-failed", 500),
        DATA_EXISTS("data-exists", 409),
        DATA_MISSING("data-missing", 404),
        OPERATION_NOT_SUPPORTED("operation-not-supported", 501),
        OPERATION_FAILED("operation-failed", 500),
        PARTIAL_OPERATION("partial-operation", 500),
        MALFORMED_MESSAGE("malformed-message", 400),
        RESOURCE_DENIED_TRANSPORT("resource-denied-transport", 503);

        private final String tagValue;
        private final int statusCode;

        private ErrorTag(String tagValue, int statusCode) {
            this.tagValue = tagValue;
            this.statusCode = statusCode;
        }

        public String getTagValue() {
            return this.tagValue.toLowerCase(Locale.ROOT);
        }

        public static ErrorTag valueOfCaseInsensitive(String value) {
            try {
                return ErrorTag.valueOf(ErrorTag.class, value.toUpperCase(Locale.ROOT).replaceAll("-", "_"));
            }
            catch (IllegalArgumentException e) {
                return OPERATION_FAILED;
            }
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }

    public static enum ErrorType {
        TRANSPORT,
        RPC,
        PROTOCOL,
        APPLICATION;


        public String getErrorTypeTag() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static ErrorType valueOfCaseInsensitive(String value) {
            try {
                return ErrorType.valueOf(ErrorType.class, value.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return APPLICATION;
            }
        }
    }
}

