/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.common.context;

import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;

public final class WriterParameters {
    private final String content;
    private final Integer depth;
    private final List<Set<QName>> fields;
    private final boolean prettyPrint;
    private final boolean tagged;

    private WriterParameters(WriterParametersBuilder builder) {
        this.content = builder.content;
        this.depth = builder.depth;
        this.fields = builder.fields;
        this.prettyPrint = builder.prettyPrint;
        this.tagged = builder.tagged;
    }

    public String getContent() {
        return this.content;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public List<Set<QName>> getFields() {
        return this.fields;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public boolean isTagged() {
        return this.tagged;
    }

    public static class WriterParametersBuilder {
        private String content;
        private Integer depth;
        private List<Set<QName>> fields;
        private boolean prettyPrint;
        private boolean tagged;

        public WriterParametersBuilder setContent(String content) {
            this.content = content;
            return this;
        }

        public WriterParametersBuilder setDepth(int depth) {
            this.depth = depth;
            return this;
        }

        public WriterParametersBuilder setFields(List<Set<QName>> fields) {
            this.fields = fields;
            return this;
        }

        public WriterParametersBuilder setPrettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public WriterParameters build() {
            return new WriterParameters(this);
        }

        public void setTagged(boolean tagged) {
            this.tagged = tagged;
        }
    }
}

