/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.common.context;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.WriterParameters;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

public class NormalizedNodeContext {
    private final InstanceIdentifierContext<? extends SchemaNode> context;
    private final NormalizedNode<?, ?> data;
    private final WriterParameters writerParameters;
    private Map<String, Object> headers = new HashMap<String, Object>();

    public NormalizedNodeContext(InstanceIdentifierContext<? extends SchemaNode> context, NormalizedNode<?, ?> data, WriterParameters writerParameters) {
        this.context = context;
        this.data = data;
        this.writerParameters = writerParameters;
    }

    public NormalizedNodeContext(InstanceIdentifierContext<? extends SchemaNode> context, NormalizedNode<?, ?> data, WriterParameters writerParameters, Map<String, Object> headers) {
        this.context = context;
        this.data = data;
        this.writerParameters = writerParameters;
        this.headers = headers;
    }

    public NormalizedNodeContext(InstanceIdentifierContext<? extends SchemaNode> context, NormalizedNode<?, ?> data) {
        this.context = context;
        this.data = data;
        this.writerParameters = new WriterParameters.WriterParametersBuilder().build();
    }

    public NormalizedNodeContext(InstanceIdentifierContext<? extends SchemaNode> context, NormalizedNode<?, ?> data, Map<String, Object> headers) {
        this.context = context;
        this.data = data;
        this.writerParameters = new WriterParameters.WriterParametersBuilder().build();
        this.headers = headers;
    }

    public InstanceIdentifierContext<? extends SchemaNode> getInstanceIdentifierContext() {
        return this.context;
    }

    public NormalizedNode<?, ?> getData() {
        return this.data;
    }

    public WriterParameters getWriterParameters() {
        return this.writerParameters;
    }

    public Map<String, Object> getNewHeaders() {
        return this.headers;
    }
}

