/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.streams.websockets;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import org.opendaylight.netconf.sal.restconf.impl.RestconfImpl;
import org.opendaylight.netconf.sal.streams.listeners.ListenerAdapter;
import org.opendaylight.netconf.sal.streams.listeners.NotificationListenerAdapter;
import org.opendaylight.netconf.sal.streams.listeners.Notificator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketServerHandler.class);
    private WebSocketServerHandshaker handshaker;

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (!req.decoderResult().isSuccess()) {
            WebSocketServerHandler.sendHttpResponse(ctx, (HttpRequest)req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            return;
        }
        if (req.method() != HttpMethod.GET) {
            WebSocketServerHandler.sendHttpResponse(ctx, (HttpRequest)req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        String streamName = Notificator.createStreamNameFromUri(req.uri());
        if (streamName.contains(RestconfImpl.DATA_SUBSCR)) {
            ListenerAdapter listener = Notificator.getListenerFor(streamName);
            if (listener != null) {
                listener.addSubscriber(ctx.channel());
                LOG.debug("Subscriber successfully registered.");
            } else {
                LOG.error("Listener for stream with name '{}' was not found.", (Object)streamName);
                WebSocketServerHandler.sendHttpResponse(ctx, (HttpRequest)req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR));
            }
        } else if (streamName.contains(RestconfImpl.NOTIFICATION_STREAM)) {
            List<NotificationListenerAdapter> listeners = Notificator.getNotificationListenerFor(streamName);
            if (listeners != null && !listeners.isEmpty()) {
                for (NotificationListenerAdapter listener : listeners) {
                    listener.addSubscriber(ctx.channel());
                    LOG.debug("Subscriber successfully registered.");
                }
            } else {
                LOG.error("Listener for stream with name '{}' was not found.", (Object)streamName);
                WebSocketServerHandler.sendHttpResponse(ctx, (HttpRequest)req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR));
            }
        }
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(WebSocketServerHandler.getWebSocketLocation((HttpRequest)req), null, false);
        this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            this.handshaker.handshake(ctx.channel(), req);
        }
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, FullHttpResponse res) {
        boolean notOkay;
        boolean bl = notOkay = !HttpResponseStatus.OK.equals((Object)res.status());
        if (notOkay) {
            res.content().writeCharSequence((CharSequence)res.status().toString(), CharsetUtil.UTF_8);
            HttpUtil.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
        }
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (notOkay || !HttpUtil.isKeepAlive((HttpMessage)req)) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            List<NotificationListenerAdapter> listeners;
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            String streamName = Notificator.createStreamNameFromUri(((CloseWebSocketFrame)frame).reasonText());
            if (streamName.contains(RestconfImpl.DATA_SUBSCR)) {
                ListenerAdapter listener = Notificator.getListenerFor(streamName);
                if (listener != null) {
                    listener.removeSubscriber(ctx.channel());
                    LOG.debug("Subscriber successfully registered.");
                    Notificator.removeListenerIfNoSubscriberExists(listener);
                }
            } else if (streamName.contains(RestconfImpl.NOTIFICATION_STREAM) && (listeners = Notificator.getNotificationListenerFor(streamName)) != null && !listeners.isEmpty()) {
                for (NotificationListenerAdapter listener : listeners) {
                    listener.removeSubscriber(ctx.channel());
                }
            }
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close();
    }

    private static String getWebSocketLocation(HttpRequest req) {
        return "ws://" + req.headers().get((CharSequence)HttpHeaderNames.HOST) + req.uri();
    }
}

