/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.streams.websockets;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.opendaylight.netconf.sal.streams.listeners.Notificator;
import org.opendaylight.netconf.sal.streams.websockets.WebSocketServerInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebSocketServer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketServer.class);
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    private static WebSocketServer instance = null;
    private final String address;
    private final int port;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    private WebSocketServer(String address, int port) {
        this.address = address;
        this.port = port;
    }

    private static WebSocketServer createInstance(int port) {
        instance = WebSocketServer.createInstance(DEFAULT_ADDRESS, port);
        return instance;
    }

    public static WebSocketServer createInstance(String address, int port) {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"createInstance() has already been called");
        Preconditions.checkNotNull((Object)address, (Object)"Address cannot be null.");
        Preconditions.checkArgument((port >= 1024 ? 1 : 0) != 0, (Object)"Privileged port (below 1024) is not allowed");
        instance = new WebSocketServer(address, port);
        return instance;
    }

    public int getPort() {
        return this.port;
    }

    public static WebSocketServer getInstance() {
        Preconditions.checkNotNull((Object)instance, (Object)"createInstance() must be called prior to getInstance()");
        return instance;
    }

    public static WebSocketServer getInstance(int fallbackPort) {
        if (instance != null) {
            return instance;
        }
        LOG.warn("No instance for WebSocketServer found, creating one with a fallback port: {}", (Object)fallbackPort);
        return WebSocketServer.createInstance(fallbackPort);
    }

    public static void destroyInstance() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"createInstance() must be called prior to destroyInstance()");
        instance.stop();
        instance = null;
    }

    @Override
    public void run() {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)serverBootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new WebSocketServerInitializer());
            Channel channel = serverBootstrap.bind(this.address, this.port).sync().channel();
            LOG.info("Web socket server started at address {}, port {}.", (Object)this.address, (Object)this.port);
            channel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            LOG.error("Web socket server encountered an error during startup attempt on port {}", (Object)this.port, (Object)e);
        }
        catch (Throwable throwable) {
            LOG.error("Error while binding to address {}, port {}", new Object[]{this.address, this.port, throwable});
            throw throwable;
        }
        finally {
            this.stop();
        }
    }

    private void stop() {
        LOG.info("Stopping the web socket server instance on port {}", (Object)this.port);
        Notificator.removeAllListeners();
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
            this.bossGroup = null;
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
        }
    }
}

