/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.streams.listeners;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import io.netty.channel.Channel;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.opendaylight.netconf.sal.streams.listeners.AbstractQueryParams;
import org.opendaylight.netconf.sal.streams.listeners.BaseListenerInterface;
import org.opendaylight.netconf.sal.streams.listeners.Event;
import org.opendaylight.netconf.sal.streams.listeners.EventBusChangeRecorder;
import org.opendaylight.netconf.sal.streams.listeners.EventType;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCommonSubscriber
extends AbstractQueryParams
implements BaseListenerInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommonSubscriber.class);
    private final Set<Channel> subscribers = ConcurrentHashMap.newKeySet();
    private final EventBus eventBus = new AsyncEventBus((Executor)Executors.newSingleThreadExecutor());
    private EventBusChangeRecorder eventBusChangeRecorder;
    private ListenerRegistration registration;

    protected AbstractCommonSubscriber() {
    }

    @Override
    public final boolean hasSubscribers() {
        return !this.subscribers.isEmpty();
    }

    @Override
    public final Set<Channel> getSubscribers() {
        return this.subscribers;
    }

    @Override
    public final void close() {
        if (this.registration != null) {
            this.registration.close();
            this.registration = null;
        }
        this.unregister();
    }

    public void addSubscriber(Channel subscriber) {
        if (!subscriber.isActive()) {
            LOG.debug("Channel is not active between websocket server and subscriber {}", (Object)subscriber.remoteAddress());
        }
        Event event = new Event(EventType.REGISTER);
        event.setSubscriber(subscriber);
        this.eventBus.post((Object)event);
    }

    public void removeSubscriber(Channel subscriber) {
        LOG.debug("Subscriber {} is removed.", (Object)subscriber.remoteAddress());
        Event event = new Event(EventType.DEREGISTER);
        event.setSubscriber(subscriber);
        this.eventBus.post((Object)event);
    }

    public void setRegistration(ListenerRegistration registration) {
        this.registration = registration;
    }

    public boolean isListening() {
        return this.registration != null;
    }

    protected <T extends BaseListenerInterface> void register(T listener) {
        this.eventBusChangeRecorder = new EventBusChangeRecorder<T>(listener);
        this.eventBus.register((Object)this.eventBusChangeRecorder);
    }

    protected void post(Event event) {
        this.eventBus.post((Object)event);
    }

    protected void unregister() {
        this.subscribers.clear();
        this.eventBus.unregister((Object)this.eventBusChangeRecorder);
    }
}

