/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.restconf.web;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.servlets.GzipFilter;
import org.opendaylight.aaa.filterchain.configuration.CustomFilterAdapterConfiguration;
import org.opendaylight.aaa.filterchain.filters.CustomFilterAdapter;
import org.opendaylight.aaa.web.FilterDetails;
import org.opendaylight.aaa.web.ServletDetails;
import org.opendaylight.aaa.web.WebContext;
import org.opendaylight.aaa.web.WebContextBuilder;
import org.opendaylight.aaa.web.WebContextRegistration;
import org.opendaylight.aaa.web.WebContextSecurer;
import org.opendaylight.aaa.web.WebServer;
import org.opendaylight.aaa.web.servlet.ServletSupport;
import org.opendaylight.netconf.sal.restconf.web.Bierman02WebRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bierman02WebRegistrarImpl
implements Bierman02WebRegistrar {
    private static final Logger LOG = LoggerFactory.getLogger(Bierman02WebRegistrarImpl.class);
    private final WebServer webServer;
    private final WebContextSecurer webContextSecurer;
    private final ServletSupport servletSupport;
    private final Application webApp;
    private final CustomFilterAdapterConfiguration customFilterAdapterConfig;
    private volatile WebContextRegistration registraton;
    private final AtomicBoolean registered = new AtomicBoolean(false);

    public Bierman02WebRegistrarImpl(WebServer webServer, WebContextSecurer webContextSecurer, ServletSupport servletSupport, Application webApp, CustomFilterAdapterConfiguration customFilterAdapterConfig) {
        this.webServer = webServer;
        this.webContextSecurer = webContextSecurer;
        this.servletSupport = servletSupport;
        this.webApp = webApp;
        this.customFilterAdapterConfig = customFilterAdapterConfig;
    }

    public void close() {
        if (this.registered.compareAndSet(true, false) && this.registraton != null) {
            this.registraton.close();
        }
    }

    @Override
    public void registerWithAuthentication() {
        this.register(true);
    }

    @Override
    public void registerWithoutAuthentication() {
        this.register(false);
    }

    private void register(boolean authenticate) {
        if (!this.registered.compareAndSet(false, true)) {
            LOG.warn("Web context has already been registered", (Throwable)new Exception("call site"));
            return;
        }
        WebContextBuilder webContextBuilder = WebContext.builder().contextPath("restconf").supportsSessions(true).addServlet(ServletDetails.builder().servlet((Servlet)this.servletSupport.createHttpServletBuilder(this.webApp).build()).addUrlPattern("/*").build()).addFilter(FilterDetails.builder().filter((Filter)new CustomFilterAdapter(this.customFilterAdapterConfig)).addUrlPattern("/*").build()).addFilter(FilterDetails.builder().filter((Filter)new GzipFilter()).putInitParam("mimeTypes", "application/xml,application/yang.data+xml,xml,application/json,application/yang.data+json").addUrlPattern("/*").build());
        if (authenticate) {
            this.webContextSecurer.requireAuthentication(webContextBuilder, new String[]{"/*"});
        }
        try {
            this.registraton = this.webServer.registerWebContext(webContextBuilder.build());
        }
        catch (ServletException e) {
            throw new RuntimeException("Failed to register the web context", e);
        }
    }
}

