/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.restconf.impl;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.netconf.sal.rest.api.RestconfService;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.patch.PatchContext;
import org.opendaylight.restconf.common.patch.PatchStatusContext;

public final class StatisticsRestconfServiceWrapper
implements RestconfService {
    AtomicLong operationalGet = new AtomicLong();
    AtomicLong configGet = new AtomicLong();
    AtomicLong rpc = new AtomicLong();
    AtomicLong configPost = new AtomicLong();
    AtomicLong configPut = new AtomicLong();
    AtomicLong configDelete = new AtomicLong();
    AtomicLong successGetConfig = new AtomicLong();
    AtomicLong successGetOperational = new AtomicLong();
    AtomicLong successPost = new AtomicLong();
    AtomicLong successPut = new AtomicLong();
    AtomicLong successDelete = new AtomicLong();
    AtomicLong failureGetConfig = new AtomicLong();
    AtomicLong failureGetOperational = new AtomicLong();
    AtomicLong failurePost = new AtomicLong();
    AtomicLong failurePut = new AtomicLong();
    AtomicLong failureDelete = new AtomicLong();
    private final RestconfService delegate;

    private StatisticsRestconfServiceWrapper(RestconfService delegate) {
        this.delegate = delegate;
    }

    public static StatisticsRestconfServiceWrapper newInstance(RestconfService delegate) {
        return new StatisticsRestconfServiceWrapper(delegate);
    }

    @Override
    public Object getRoot() {
        return this.delegate.getRoot();
    }

    @Override
    public NormalizedNodeContext getModules(UriInfo uriInfo) {
        return this.delegate.getModules(uriInfo);
    }

    @Override
    public NormalizedNodeContext getModules(String identifier, UriInfo uriInfo) {
        return this.delegate.getModules(identifier, uriInfo);
    }

    @Override
    public NormalizedNodeContext getModule(String identifier, UriInfo uriInfo) {
        return this.delegate.getModule(identifier, uriInfo);
    }

    @Override
    public NormalizedNodeContext getOperations(UriInfo uriInfo) {
        return this.delegate.getOperations(uriInfo);
    }

    @Override
    public NormalizedNodeContext getOperations(String identifier, UriInfo uriInfo) {
        return this.delegate.getOperations(identifier, uriInfo);
    }

    @Override
    public NormalizedNodeContext invokeRpc(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        this.rpc.incrementAndGet();
        return this.delegate.invokeRpc(identifier, payload, uriInfo);
    }

    @Override
    public NormalizedNodeContext invokeRpc(String identifier, String noPayload, UriInfo uriInfo) {
        this.rpc.incrementAndGet();
        return this.delegate.invokeRpc(identifier, noPayload, uriInfo);
    }

    @Override
    public NormalizedNodeContext readConfigurationData(String identifier, UriInfo uriInfo) {
        this.configGet.incrementAndGet();
        NormalizedNodeContext normalizedNodeContext = null;
        try {
            normalizedNodeContext = this.delegate.readConfigurationData(identifier, uriInfo);
            if (normalizedNodeContext.getData() != null) {
                this.successGetConfig.incrementAndGet();
            } else {
                this.failureGetConfig.incrementAndGet();
            }
        }
        catch (Exception e) {
            this.failureGetConfig.incrementAndGet();
            throw e;
        }
        return normalizedNodeContext;
    }

    @Override
    public NormalizedNodeContext readOperationalData(String identifier, UriInfo uriInfo) {
        this.operationalGet.incrementAndGet();
        NormalizedNodeContext normalizedNodeContext = null;
        try {
            normalizedNodeContext = this.delegate.readOperationalData(identifier, uriInfo);
            if (normalizedNodeContext.getData() != null) {
                this.successGetOperational.incrementAndGet();
            } else {
                this.failureGetOperational.incrementAndGet();
            }
        }
        catch (Exception e) {
            this.failureGetOperational.incrementAndGet();
            throw e;
        }
        return normalizedNodeContext;
    }

    @Override
    public Response updateConfigurationData(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        this.configPut.incrementAndGet();
        Response response = null;
        try {
            response = this.delegate.updateConfigurationData(identifier, payload, uriInfo);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                this.successPut.incrementAndGet();
            } else {
                this.failurePut.incrementAndGet();
            }
        }
        catch (Exception e) {
            this.failurePut.incrementAndGet();
            throw e;
        }
        return response;
    }

    @Override
    public Response createConfigurationData(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        this.configPost.incrementAndGet();
        Response response = null;
        try {
            response = this.delegate.createConfigurationData(identifier, payload, uriInfo);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                this.successPost.incrementAndGet();
            } else {
                this.failurePost.incrementAndGet();
            }
        }
        catch (Exception e) {
            this.failurePost.incrementAndGet();
            throw e;
        }
        return response;
    }

    @Override
    public Response createConfigurationData(NormalizedNodeContext payload, UriInfo uriInfo) {
        this.configPost.incrementAndGet();
        Response response = null;
        try {
            response = this.delegate.createConfigurationData(payload, uriInfo);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                this.successPost.incrementAndGet();
            } else {
                this.failurePost.incrementAndGet();
            }
        }
        catch (Exception e) {
            this.failurePost.incrementAndGet();
            throw e;
        }
        return response;
    }

    @Override
    public Response deleteConfigurationData(String identifier) {
        this.configDelete.incrementAndGet();
        Response response = null;
        try {
            response = this.delegate.deleteConfigurationData(identifier);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                this.successDelete.incrementAndGet();
            } else {
                this.failureDelete.incrementAndGet();
            }
        }
        catch (Exception e) {
            this.failureDelete.incrementAndGet();
            throw e;
        }
        return response;
    }

    @Override
    public NormalizedNodeContext subscribeToStream(String identifier, UriInfo uriInfo) {
        return this.delegate.subscribeToStream(identifier, uriInfo);
    }

    @Override
    public NormalizedNodeContext getAvailableStreams(UriInfo uriInfo) {
        return this.delegate.getAvailableStreams(uriInfo);
    }

    @Override
    public PatchStatusContext patchConfigurationData(String identifier, PatchContext payload, UriInfo uriInfo) {
        return this.delegate.patchConfigurationData(identifier, payload, uriInfo);
    }

    @Override
    public PatchStatusContext patchConfigurationData(PatchContext payload, UriInfo uriInfo) {
        return this.delegate.patchConfigurationData(payload, uriInfo);
    }

    public BigInteger getConfigDelete() {
        return BigInteger.valueOf(this.configDelete.get());
    }

    public BigInteger getConfigGet() {
        return BigInteger.valueOf(this.configGet.get());
    }

    public BigInteger getConfigPost() {
        return BigInteger.valueOf(this.configPost.get());
    }

    public BigInteger getConfigPut() {
        return BigInteger.valueOf(this.configPut.get());
    }

    public BigInteger getOperationalGet() {
        return BigInteger.valueOf(this.operationalGet.get());
    }

    public BigInteger getRpc() {
        return BigInteger.valueOf(this.rpc.get());
    }

    public BigInteger getSuccessGetConfig() {
        return BigInteger.valueOf(this.successGetConfig.get());
    }

    public BigInteger getSuccessGetOperational() {
        return BigInteger.valueOf(this.successGetOperational.get());
    }

    public BigInteger getSuccessPost() {
        return BigInteger.valueOf(this.successPost.get());
    }

    public BigInteger getSuccessPut() {
        return BigInteger.valueOf(this.successPut.get());
    }

    public BigInteger getSuccessDelete() {
        return BigInteger.valueOf(this.successDelete.get());
    }

    public BigInteger getFailureGetConfig() {
        return BigInteger.valueOf(this.failureGetConfig.get());
    }

    public BigInteger getFailureGetOperational() {
        return BigInteger.valueOf(this.failureGetOperational.get());
    }

    public BigInteger getFailurePost() {
        return BigInteger.valueOf(this.failurePost.get());
    }

    public BigInteger getFailurePut() {
        return BigInteger.valueOf(this.failurePut.get());
    }

    public BigInteger getFailureDelete() {
        return BigInteger.valueOf(this.failureDelete.get());
    }
}

