/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.restconf.impl;

import com.google.common.base.Strings;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.restconf.common.context.WriterParameters;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;

public final class QueryParametersParser {
    private QueryParametersParser() {
    }

    public static WriterParameters parseWriterParameters(UriInfo info) {
        return QueryParametersParser.parseParams(info, false);
    }

    public static WriterParameters parseWriterParameters(UriInfo uriInfo, boolean tagged) {
        return QueryParametersParser.parseParams(uriInfo, tagged);
    }

    private static WriterParameters parseParams(UriInfo info, boolean tagged) {
        WriterParameters.WriterParametersBuilder wpBuilder = new WriterParameters.WriterParametersBuilder();
        wpBuilder.setTagged(tagged);
        if (info == null) {
            return wpBuilder.build();
        }
        String param = (String)info.getQueryParameters(false).getFirst((Object)UriParameters.DEPTH.toString());
        if (!Strings.isNullOrEmpty((String)param) && !"unbounded".equals(param)) {
            try {
                int depth = Integer.parseInt(param);
                if (depth < 1) {
                    throw new RestconfDocumentedException(new RestconfError(RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE, "Invalid depth parameter: " + depth, null, "The depth parameter must be an integer > 1 or \"unbounded\""));
                }
                wpBuilder.setDepth(depth);
            }
            catch (NumberFormatException e) {
                throw new RestconfDocumentedException((Throwable)e, new RestconfError(RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE, "Invalid depth parameter: " + e.getMessage(), null, "The depth parameter must be an integer > 1 or \"unbounded\""));
            }
        }
        param = (String)info.getQueryParameters(false).getFirst((Object)UriParameters.PRETTY_PRINT.toString());
        wpBuilder.setPrettyPrint("true".equals(param));
        return wpBuilder.build();
    }

    private static enum UriParameters {
        PRETTY_PRINT("prettyPrint"),
        DEPTH("depth");

        private final String uriParameterName;

        private UriParameters(String uriParameterName) {
            this.uriParameterName = uriParameterName;
        }

        public String toString() {
            return this.uriParameterName;
        }
    }
}

