/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.restconf.impl;

import java.util.Collection;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.MixinNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;

class NormalizedDataPrunner {
    NormalizedDataPrunner() {
    }

    public DataContainerChild<?, ?> pruneDataAtDepth(DataContainerChild<?, ?> node, Integer depth) {
        if (depth == null) {
            return node;
        }
        if (node instanceof LeafNode || node instanceof LeafSetNode || node instanceof AnyXmlNode || node instanceof OrderedLeafSetNode) {
            return node;
        }
        if (node instanceof MixinNode) {
            return this.processMixinNode((NormalizedNode<?, ?>)node, depth);
        }
        if (node instanceof DataContainerNode) {
            return this.processContainerNode((NormalizedNode<?, ?>)node, depth);
        }
        throw new IllegalStateException("Unexpected Mixin node occured why pruning data to requested depth");
    }

    private DataContainerChild<?, ?> processMixinNode(NormalizedNode<?, ?> node, Integer depth) {
        if (node instanceof AugmentationNode) {
            return this.processAugmentationNode(node, depth);
        }
        if (node instanceof ChoiceNode) {
            return this.processChoiceNode(node, depth);
        }
        if (node instanceof OrderedMapNode) {
            return this.processOrderedMapNode(node, depth);
        }
        if (node instanceof MapNode) {
            return this.processMapNode(node, depth);
        }
        if (node instanceof UnkeyedListNode) {
            return this.processUnkeyedListNode(node, depth);
        }
        throw new IllegalStateException("Unexpected Mixin node occured why pruning data to requested depth");
    }

    private DataContainerChild<?, ?> processContainerNode(NormalizedNode<?, ?> node, Integer depth) {
        ContainerNode containerNode = (ContainerNode)node;
        DataContainerNodeAttrBuilder newContainerBuilder = Builders.containerBuilder().withNodeIdentifier(containerNode.getIdentifier());
        if (depth > 1) {
            this.processDataContainerChild((DataContainerNode<?>)((DataContainerNode)node), depth, (DataContainerNodeBuilder<? extends YangInstanceIdentifier.PathArgument, ? extends DataContainerNode<?>>)newContainerBuilder);
        }
        return (DataContainerChild)newContainerBuilder.build();
    }

    private DataContainerChild<?, ?> processChoiceNode(NormalizedNode<?, ?> node, Integer depth) {
        ChoiceNode choiceNode = (ChoiceNode)node;
        DataContainerNodeBuilder newChoiceBuilder = Builders.choiceBuilder().withNodeIdentifier(choiceNode.getIdentifier());
        this.processDataContainerChild((DataContainerNode)node, depth, newChoiceBuilder);
        return (DataContainerChild)newChoiceBuilder.build();
    }

    private DataContainerChild<?, ?> processAugmentationNode(NormalizedNode<?, ?> node, Integer depth) {
        AugmentationNode augmentationNode = (AugmentationNode)node;
        DataContainerNodeBuilder newAugmentationBuilder = Builders.augmentationBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)augmentationNode.getIdentifier());
        this.processDataContainerChild((DataContainerNode)node, depth, newAugmentationBuilder);
        return (DataContainerChild)newAugmentationBuilder.build();
    }

    private void processDataContainerChild(DataContainerNode<?> node, Integer depth, DataContainerNodeBuilder<? extends YangInstanceIdentifier.PathArgument, ? extends DataContainerNode<?>> newBuilder) {
        for (DataContainerChild nodeValue : node.getValue()) {
            newBuilder.withChild(this.pruneDataAtDepth(nodeValue, depth - 1));
        }
    }

    private DataContainerChild<?, ?> processUnkeyedListNode(NormalizedNode<?, ?> node, Integer depth) {
        CollectionNodeBuilder newUnkeyedListBuilder = Builders.unkeyedListBuilder();
        if (depth > 1) {
            for (UnkeyedListEntryNode oldUnkeyedListEntry : (Collection)((UnkeyedListNode)node).getValue()) {
                DataContainerNodeAttrBuilder newUnkeyedListEntry = Builders.unkeyedListEntryBuilder().withNodeIdentifier(oldUnkeyedListEntry.getIdentifier());
                for (DataContainerChild oldUnkeyedListEntryValue : oldUnkeyedListEntry.getValue()) {
                    newUnkeyedListEntry.withChild(this.pruneDataAtDepth(oldUnkeyedListEntryValue, depth - 1));
                }
                newUnkeyedListBuilder.addChild(newUnkeyedListEntry.build());
            }
        }
        return (DataContainerChild)newUnkeyedListBuilder.build();
    }

    private DataContainerChild<?, ?> processOrderedMapNode(NormalizedNode<?, ?> node, Integer depth) {
        CollectionNodeBuilder newOrderedMapNodeBuilder = Builders.orderedMapBuilder();
        this.processMapEntries(node, depth, (CollectionNodeBuilder<MapEntryNode, ? extends MapNode>)newOrderedMapNodeBuilder);
        return (DataContainerChild)newOrderedMapNodeBuilder.build();
    }

    private DataContainerChild<?, ?> processMapNode(NormalizedNode<?, ?> node, Integer depth) {
        CollectionNodeBuilder newMapNodeBuilder = Builders.mapBuilder();
        this.processMapEntries(node, depth, (CollectionNodeBuilder<MapEntryNode, ? extends MapNode>)newMapNodeBuilder);
        return (DataContainerChild)newMapNodeBuilder.build();
    }

    private void processMapEntries(NormalizedNode<?, ?> node, Integer depth, CollectionNodeBuilder<MapEntryNode, ? extends MapNode> newOrderedMapNodeBuilder) {
        if (depth > 1) {
            for (MapEntryNode oldMapEntryNode : ((MapNode)node).getValue()) {
                DataContainerNodeAttrBuilder newMapEntryNodeBuilder = Builders.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)oldMapEntryNode.getIdentifier());
                for (DataContainerChild mapEntryNodeValue : oldMapEntryNode.getValue()) {
                    newMapEntryNodeBuilder.withChild(this.pruneDataAtDepth(mapEntryNodeValue, depth - 1));
                }
                newOrderedMapNodeBuilder.withChild(newMapEntryNodeBuilder.build());
            }
        }
    }
}

