/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.restconf.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.sal.rest.api.RestconfService;
import org.opendaylight.netconf.sal.rest.impl.JsonNormalizedNodeBodyReader;
import org.opendaylight.netconf.sal.rest.impl.JsonToPatchBodyReader;
import org.opendaylight.netconf.sal.rest.impl.NormalizedNodeJsonBodyWriter;
import org.opendaylight.netconf.sal.rest.impl.PatchJsonBodyWriter;
import org.opendaylight.netconf.sal.restconf.api.JSONRestconfService;
import org.opendaylight.netconf.sal.restconf.impl.ControllerContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.patch.PatchContext;
import org.opendaylight.restconf.common.patch.PatchStatusContext;
import org.opendaylight.restconf.common.util.MultivaluedHashMap;
import org.opendaylight.restconf.common.util.SimpleUriInfo;
import org.opendaylight.yangtools.yang.common.OperationFailedException;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JSONRestconfServiceImpl
implements JSONRestconfService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(JSONRestconfServiceImpl.class);
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final ControllerContext controllerContext;
    private final RestconfService restconfService;

    public JSONRestconfServiceImpl(ControllerContext controllerContext, RestconfService restconfService) {
        this.controllerContext = controllerContext;
        this.restconfService = restconfService;
    }

    @Override
    public void put(String uriPath, String payload) throws OperationFailedException {
        Preconditions.checkNotNull((Object)payload, (Object)"payload can't be null");
        LOG.debug("put: uriPath: {}, payload: {}", (Object)uriPath, (Object)payload);
        ByteArrayInputStream entityStream = new ByteArrayInputStream(payload.getBytes(StandardCharsets.UTF_8));
        NormalizedNodeContext context = JsonNormalizedNodeBodyReader.readFrom(uriPath, entityStream, false, this.controllerContext);
        LOG.debug("Parsed YangInstanceIdentifier: {}", (Object)context.getInstanceIdentifierContext().getInstanceIdentifier());
        LOG.debug("Parsed NormalizedNode: {}", (Object)context.getData());
        try {
            this.restconfService.updateConfigurationData(uriPath, context, (UriInfo)new SimpleUriInfo(uriPath));
        }
        catch (Exception e) {
            JSONRestconfServiceImpl.propagateExceptionAs(uriPath, e, "PUT");
        }
    }

    @Override
    public void post(String uriPath, String payload) throws OperationFailedException {
        Preconditions.checkNotNull((Object)payload, (Object)"payload can't be null");
        LOG.debug("post: uriPath: {}, payload: {}", (Object)uriPath, (Object)payload);
        ByteArrayInputStream entityStream = new ByteArrayInputStream(payload.getBytes(StandardCharsets.UTF_8));
        NormalizedNodeContext context = JsonNormalizedNodeBodyReader.readFrom(uriPath, entityStream, true, this.controllerContext);
        LOG.debug("Parsed YangInstanceIdentifier: {}", (Object)context.getInstanceIdentifierContext().getInstanceIdentifier());
        LOG.debug("Parsed NormalizedNode: {}", (Object)context.getData());
        try {
            this.restconfService.createConfigurationData(uriPath, context, (UriInfo)new SimpleUriInfo(uriPath));
        }
        catch (Exception e) {
            JSONRestconfServiceImpl.propagateExceptionAs(uriPath, e, "POST");
        }
    }

    @Override
    public void delete(String uriPath) throws OperationFailedException {
        LOG.debug("delete: uriPath: {}", (Object)uriPath);
        try {
            this.restconfService.deleteConfigurationData(uriPath);
        }
        catch (Exception e) {
            JSONRestconfServiceImpl.propagateExceptionAs(uriPath, e, "DELETE");
        }
    }

    @Override
    public Optional<String> get(String uriPath, LogicalDatastoreType datastoreType) throws OperationFailedException {
        LOG.debug("get: uriPath: {}", (Object)uriPath);
        try {
            SimpleUriInfo uriInfo = new SimpleUriInfo(uriPath);
            NormalizedNodeContext readData = datastoreType == LogicalDatastoreType.CONFIGURATION ? this.restconfService.readConfigurationData(uriPath, (UriInfo)uriInfo) : this.restconfService.readOperationalData(uriPath, (UriInfo)uriInfo);
            Optional result = Optional.of((Object)JSONRestconfServiceImpl.toJson(readData));
            LOG.debug("get returning: {}", result.get());
            return result;
        }
        catch (Exception e) {
            if (!JSONRestconfServiceImpl.isDataMissing(e)) {
                JSONRestconfServiceImpl.propagateExceptionAs(uriPath, e, "GET");
            }
            LOG.debug("Data missing - returning absent");
            return Optional.absent();
        }
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"}, justification="Unrecognised NullableDecl")
    public Optional<String> invokeRpc(String uriPath, Optional<String> input) throws OperationFailedException {
        Preconditions.checkNotNull((Object)uriPath, (Object)"uriPath can't be null");
        String actualInput = input.isPresent() ? (String)input.get() : null;
        LOG.debug("invokeRpc: uriPath: {}, input: {}", (Object)uriPath, (Object)actualInput);
        String output = null;
        try {
            NormalizedNodeContext outputContext;
            if (actualInput != null) {
                ByteArrayInputStream entityStream = new ByteArrayInputStream(actualInput.getBytes(StandardCharsets.UTF_8));
                NormalizedNodeContext inputContext = JsonNormalizedNodeBodyReader.readFrom(uriPath, entityStream, true, this.controllerContext);
                LOG.debug("Parsed YangInstanceIdentifier: {}", (Object)inputContext.getInstanceIdentifierContext().getInstanceIdentifier());
                LOG.debug("Parsed NormalizedNode: {}", (Object)inputContext.getData());
                outputContext = this.restconfService.invokeRpc(uriPath, inputContext, null);
            } else {
                outputContext = this.restconfService.invokeRpc(uriPath, "", null);
            }
            if (outputContext.getData() != null) {
                output = JSONRestconfServiceImpl.toJson(outputContext);
            }
        }
        catch (IOException | RuntimeException e) {
            JSONRestconfServiceImpl.propagateExceptionAs(uriPath, e, "RPC");
        }
        return Optional.fromNullable(output);
    }

    @Override
    public Optional<String> patch(String uriPath, String payload) throws OperationFailedException {
        String output = null;
        Preconditions.checkNotNull((Object)payload, (Object)"payload can't be null");
        LOG.debug("patch: uriPath: {}, payload: {}", (Object)uriPath, (Object)payload);
        ByteArrayInputStream entityStream = new ByteArrayInputStream(payload.getBytes(StandardCharsets.UTF_8));
        JsonToPatchBodyReader jsonToPatchBodyReader = new JsonToPatchBodyReader(this.controllerContext);
        PatchContext context = jsonToPatchBodyReader.readFrom(uriPath, (InputStream)entityStream);
        LOG.debug("Parsed YangInstanceIdentifier: {}", (Object)context.getInstanceIdentifierContext().getInstanceIdentifier());
        LOG.debug("Parsed NormalizedNode: {}", (Object)context.getData());
        try {
            PatchStatusContext patchStatusContext = this.restconfService.patchConfigurationData(context, (UriInfo)new SimpleUriInfo(uriPath));
            output = this.toJson(patchStatusContext);
        }
        catch (Exception e) {
            JSONRestconfServiceImpl.propagateExceptionAs(uriPath, e, "PATCH");
        }
        return Optional.fromNullable(output);
    }

    @Override
    public Optional<String> subscribeToStream(@Nonnull String identifier, MultivaluedMap<String, String> params) throws OperationFailedException {
        String uri = "http://127.0.0.1:8081/restconf/streams/stream/" + identifier;
        MultivaluedHashMap queryParams = params != null ? params : new MultivaluedHashMap();
        SimpleUriInfo uriInfo = new SimpleUriInfo(uri, (MultivaluedMap)queryParams);
        String jsonRes = null;
        try {
            NormalizedNodeContext res = this.restconfService.subscribeToStream(identifier, (UriInfo)uriInfo);
            jsonRes = JSONRestconfServiceImpl.toJson(res);
        }
        catch (Exception e) {
            JSONRestconfServiceImpl.propagateExceptionAs(identifier, e, "RPC");
        }
        return Optional.fromNullable(jsonRes);
    }

    @Override
    public void close() {
    }

    private String toJson(PatchStatusContext patchStatusContext) throws IOException {
        PatchJsonBodyWriter writer = new PatchJsonBodyWriter();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        writer.writeTo(patchStatusContext, PatchStatusContext.class, null, EMPTY_ANNOTATIONS, MediaType.APPLICATION_JSON_TYPE, null, (OutputStream)outputStream);
        return outputStream.toString(StandardCharsets.UTF_8.name());
    }

    private static String toJson(NormalizedNodeContext readData) throws IOException {
        NormalizedNodeJsonBodyWriter writer = new NormalizedNodeJsonBodyWriter();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        writer.writeTo(readData, NormalizedNodeContext.class, null, EMPTY_ANNOTATIONS, MediaType.APPLICATION_JSON_TYPE, null, (OutputStream)outputStream);
        return outputStream.toString(StandardCharsets.UTF_8.name());
    }

    private static boolean isDataMissing(Exception exception) {
        RestconfDocumentedException rde;
        boolean dataMissing = false;
        if (exception instanceof RestconfDocumentedException && !(rde = (RestconfDocumentedException)((Object)exception)).getErrors().isEmpty() && ((RestconfError)rde.getErrors().get(0)).getErrorTag() == RestconfError.ErrorTag.DATA_MISSING) {
            dataMissing = true;
        }
        return dataMissing;
    }

    private static void propagateExceptionAs(String uriPath, Exception exception, String operation) throws OperationFailedException {
        LOG.debug("Error for uriPath: {}", (Object)uriPath, (Object)exception);
        if (exception instanceof RestconfDocumentedException) {
            throw new OperationFailedException(String.format("%s failed for URI %s", operation, uriPath), exception.getCause(), JSONRestconfServiceImpl.toRpcErrors(((RestconfDocumentedException)((Object)exception)).getErrors()));
        }
        throw new OperationFailedException(String.format("%s failed for URI %s", operation, uriPath), (Throwable)exception, new RpcError[0]);
    }

    private static RpcError[] toRpcErrors(List<RestconfError> from) {
        RpcError[] to = new RpcError[from.size()];
        int index = 0;
        for (RestconfError e : from) {
            to[index++] = RpcResultBuilder.newError((RpcError.ErrorType)JSONRestconfServiceImpl.toRpcErrorType(e.getErrorType()), (String)e.getErrorTag().getTagValue(), (String)e.getErrorMessage());
        }
        return to;
    }

    private static RpcError.ErrorType toRpcErrorType(RestconfError.ErrorType errorType) {
        switch (errorType) {
            case TRANSPORT: {
                return RpcError.ErrorType.TRANSPORT;
            }
            case RPC: {
                return RpcError.ErrorType.RPC;
            }
            case PROTOCOL: {
                return RpcError.ErrorType.PROTOCOL;
            }
        }
        return RpcError.ErrorType.APPLICATION;
    }
}

