/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.restconf.impl;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.netconf.sal.restconf.impl.FakeModuleImport;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

final class FakeRestconfModule
implements Module {
    static final QNameModule QNAME = QNameModule.create((URI)URI.create("urn:ietf:params:xml:ns:yang:ietf-restconf"), (Revision)Revision.of((String)"2016-06-28")).intern();
    private final Collection<DataSchemaNode> children;
    private final ImmutableSet<ModuleImport> imports;

    FakeRestconfModule(Collection<Module> neededModules, ContainerSchemaNode child) {
        this.children = ImmutableList.of((Object)child);
        this.imports = ImmutableSet.copyOf((Collection)Collections2.transform(neededModules, FakeModuleImport::new));
    }

    public Set<TypeDefinition<?>> getTypeDefinitions() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public Collection<DataSchemaNode> getChildNodes() {
        return this.children;
    }

    public Set<GroupingDefinition> getGroupings() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public Optional<DataSchemaNode> findDataChildByName(QName name) {
        for (DataSchemaNode node : this.children) {
            if (!node.getQName().equals((Object)name)) continue;
            return Optional.of(node);
        }
        throw new RestconfDocumentedException(name + " is not in child of " + QNAME);
    }

    public Set<UsesNode> getUses() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public QNameModule getQNameModule() {
        return QNAME;
    }

    public String getName() {
        return "ietf-restconf";
    }

    public URI getNamespace() {
        return QNAME.getNamespace();
    }

    public Optional<Revision> getRevision() {
        return QNAME.getRevision();
    }

    public String getPrefix() {
        return "restconf";
    }

    public YangVersion getYangVersion() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public Optional<String> getDescription() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public Optional<String> getReference() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public Optional<String> getOrganization() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public Optional<String> getContact() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public Set<ModuleImport> getImports() {
        return this.imports;
    }

    public Set<Module> getSubmodules() {
        return ImmutableSet.of();
    }

    public Set<FeatureDefinition> getFeatures() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public Set<NotificationDefinition> getNotifications() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public Set<AugmentationSchemaNode> getAugmentations() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public Set<RpcDefinition> getRpcs() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public Set<Deviation> getDeviations() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public Set<IdentitySchemaNode> getIdentities() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public List<ExtensionDefinition> getExtensionSchemaNodes() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        throw new UnsupportedOperationException("Not supported operations.");
    }

    public Optional<SemVer> getSemanticVersion() {
        throw new UnsupportedOperationException("Not supported operations.");
    }
}

