/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.restconf.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.Response;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.sal.restconf.impl.BatchedExistenceCheck;
import org.opendaylight.netconf.sal.restconf.impl.ControllerContext;
import org.opendaylight.netconf.sal.restconf.impl.PutResult;
import org.opendaylight.netconf.sal.streams.listeners.ListenerAdapter;
import org.opendaylight.netconf.sal.streams.listeners.NotificationListenerAdapter;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.patch.PatchContext;
import org.opendaylight.restconf.common.patch.PatchEditOperation;
import org.opendaylight.restconf.common.patch.PatchEntity;
import org.opendaylight.restconf.common.patch.PatchStatusContext;
import org.opendaylight.restconf.common.patch.PatchStatusEntity;
import org.opendaylight.restconf.common.util.DataChangeScope;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.common.OperationFailedException;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerFacade
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerFacade.class);
    private volatile DOMRpcService rpcService;
    private final DOMDataBroker domDataBroker;
    private final DOMNotificationService domNotification;
    private final ControllerContext controllerContext;

    private BrokerFacade(DOMRpcService rpcService, DOMDataBroker domDataBroker, DOMNotificationService domNotification, ControllerContext controllerContext) {
        this.rpcService = Objects.requireNonNull(rpcService);
        this.domDataBroker = Objects.requireNonNull(domDataBroker);
        this.domNotification = Objects.requireNonNull(domNotification);
        this.controllerContext = Objects.requireNonNull(controllerContext);
    }

    public static BrokerFacade newInstance(DOMRpcService rpcService, DOMDataBroker domDataBroker, DOMNotificationService domNotification, ControllerContext controllerContext) {
        return new BrokerFacade(rpcService, domDataBroker, domNotification, controllerContext);
    }

    @Override
    public void close() {
    }

    public NormalizedNode<?, ?> readConfigurationData(YangInstanceIdentifier path) {
        return this.readConfigurationData(path, null);
    }

    public NormalizedNode<?, ?> readConfigurationData(YangInstanceIdentifier path, String withDefa) {
        try (DOMDataTreeReadTransaction tx = this.domDataBroker.newReadOnlyTransaction();){
            NormalizedNode<?, ?> normalizedNode = this.readDataViaTransaction(tx, LogicalDatastoreType.CONFIGURATION, path, withDefa);
            return normalizedNode;
        }
    }

    public NormalizedNode<?, ?> readConfigurationData(DOMMountPoint mountPoint, YangInstanceIdentifier path) {
        return this.readConfigurationData(mountPoint, path, null);
    }

    public NormalizedNode<?, ?> readConfigurationData(DOMMountPoint mountPoint, YangInstanceIdentifier path, String withDefa) {
        Optional domDataBrokerService = mountPoint.getService(DOMDataBroker.class);
        if (domDataBrokerService.isPresent()) {
            try (DOMDataTreeReadTransaction tx = ((DOMDataBroker)domDataBrokerService.get()).newReadOnlyTransaction();){
                NormalizedNode<?, ?> normalizedNode = this.readDataViaTransaction(tx, LogicalDatastoreType.CONFIGURATION, path, withDefa);
                return normalizedNode;
            }
        }
        throw BrokerFacade.dataBrokerUnavailable(path);
    }

    public NormalizedNode<?, ?> readOperationalData(YangInstanceIdentifier path) {
        try (DOMDataTreeReadTransaction tx = this.domDataBroker.newReadOnlyTransaction();){
            NormalizedNode<?, ?> normalizedNode = this.readDataViaTransaction(tx, LogicalDatastoreType.OPERATIONAL, path);
            return normalizedNode;
        }
    }

    public NormalizedNode<?, ?> readOperationalData(DOMMountPoint mountPoint, YangInstanceIdentifier path) {
        Optional domDataBrokerService = mountPoint.getService(DOMDataBroker.class);
        if (domDataBrokerService.isPresent()) {
            try (DOMDataTreeReadTransaction tx = ((DOMDataBroker)domDataBrokerService.get()).newReadOnlyTransaction();){
                NormalizedNode<?, ?> normalizedNode = this.readDataViaTransaction(tx, LogicalDatastoreType.OPERATIONAL, path);
                return normalizedNode;
            }
        }
        throw BrokerFacade.dataBrokerUnavailable(path);
    }

    public PutResult commitConfigurationDataPut(SchemaContext globalSchema, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, String insert, String point) {
        Preconditions.checkNotNull((Object)globalSchema);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull(payload);
        DOMDataTreeReadWriteTransaction newReadWriteTransaction = this.domDataBroker.newReadWriteTransaction();
        Response.Status status = this.readDataViaTransaction((DOMDataTreeReadTransaction)newReadWriteTransaction, LogicalDatastoreType.CONFIGURATION, path) != null ? Response.Status.OK : Response.Status.CREATED;
        FluentFuture<? extends CommitInfo> future = this.putDataViaTransaction(newReadWriteTransaction, LogicalDatastoreType.CONFIGURATION, path, payload, globalSchema, insert, point);
        return new PutResult(status, future);
    }

    public PutResult commitMountPointDataPut(DOMMountPoint mountPoint, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, String insert, String point) {
        Preconditions.checkNotNull((Object)mountPoint);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull(payload);
        Optional domDataBrokerService = mountPoint.getService(DOMDataBroker.class);
        if (domDataBrokerService.isPresent()) {
            DOMDataTreeReadWriteTransaction newReadWriteTransaction = ((DOMDataBroker)domDataBrokerService.get()).newReadWriteTransaction();
            Response.Status status = this.readDataViaTransaction((DOMDataTreeReadTransaction)newReadWriteTransaction, LogicalDatastoreType.CONFIGURATION, path) != null ? Response.Status.OK : Response.Status.CREATED;
            FluentFuture<? extends CommitInfo> future = this.putDataViaTransaction(newReadWriteTransaction, LogicalDatastoreType.CONFIGURATION, path, payload, mountPoint.getSchemaContext(), insert, point);
            return new PutResult(status, future);
        }
        throw BrokerFacade.dataBrokerUnavailable(path);
    }

    public PatchStatusContext patchConfigurationDataWithinTransaction(final PatchContext patchContext) throws Exception {
        DOMDataTreeReadWriteTransaction patchTransaction;
        SchemaContext schemaContext;
        DOMMountPoint mountPoint = patchContext.getInstanceIdentifierContext().getMountPoint();
        if (mountPoint == null) {
            schemaContext = patchContext.getInstanceIdentifierContext().getSchemaContext();
            patchTransaction = this.domDataBroker.newReadWriteTransaction();
        } else {
            schemaContext = mountPoint.getSchemaContext();
            Optional optional = mountPoint.getService(DOMDataBroker.class);
            if (optional.isPresent()) {
                patchTransaction = ((DOMDataBroker)optional.get()).newReadWriteTransaction();
            } else {
                LOG.error("Http Patch {} has failed - device {} does not support broker service", (Object)patchContext.getPatchId(), mountPoint.getIdentifier());
                return new PatchStatusContext(patchContext.getPatchId(), null, false, (List)ImmutableList.of((Object)new RestconfError(RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.OPERATION_FAILED, "DOM data broker service isn't available for mount point " + mountPoint.getIdentifier())));
            }
        }
        final ArrayList<PatchStatusEntity> editCollection = new ArrayList<PatchStatusEntity>();
        boolean withoutError = true;
        block14: for (PatchEntity patchEntity : patchContext.getData()) {
            PatchEditOperation operation = patchEntity.getOperation();
            switch (operation) {
                case CREATE: {
                    ArrayList editErrors;
                    if (!withoutError) continue block14;
                    try {
                        this.postDataWithinTransaction(patchTransaction, LogicalDatastoreType.CONFIGURATION, patchEntity.getTargetNode(), patchEntity.getNode(), schemaContext);
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), true, null));
                    }
                    catch (RestconfDocumentedException e) {
                        LOG.error("Error call http Patch operation {} on target {}", (Object)operation, (Object)patchEntity.getTargetNode().toString());
                        editErrors = new ArrayList();
                        editErrors.addAll(e.getErrors());
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), false, editErrors));
                        withoutError = false;
                    }
                    continue block14;
                }
                case REPLACE: {
                    ArrayList editErrors;
                    if (!withoutError) continue block14;
                    try {
                        this.putDataWithinTransaction(patchTransaction, LogicalDatastoreType.CONFIGURATION, patchEntity.getTargetNode(), patchEntity.getNode(), schemaContext);
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), true, null));
                    }
                    catch (RestconfDocumentedException e) {
                        LOG.error("Error call http Patch operation {} on target {}", (Object)operation, (Object)patchEntity.getTargetNode().toString());
                        editErrors = new ArrayList();
                        editErrors.addAll(e.getErrors());
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), false, editErrors));
                        withoutError = false;
                    }
                    continue block14;
                }
                case DELETE: 
                case REMOVE: {
                    ArrayList editErrors;
                    if (!withoutError) continue block14;
                    try {
                        BrokerFacade.deleteDataWithinTransaction((DOMDataTreeWriteTransaction)patchTransaction, LogicalDatastoreType.CONFIGURATION, patchEntity.getTargetNode());
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), true, null));
                    }
                    catch (RestconfDocumentedException e) {
                        LOG.error("Error call http Patch operation {} on target {}", (Object)operation, (Object)patchEntity.getTargetNode().toString());
                        editErrors = new ArrayList();
                        editErrors.addAll(e.getErrors());
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), false, editErrors));
                        withoutError = false;
                    }
                    continue block14;
                }
                case MERGE: {
                    ArrayList editErrors;
                    if (!withoutError) continue block14;
                    try {
                        BrokerFacade.mergeDataWithinTransaction((DOMDataTreeWriteTransaction)patchTransaction, LogicalDatastoreType.CONFIGURATION, patchEntity.getTargetNode(), patchEntity.getNode(), schemaContext);
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), true, null));
                    }
                    catch (RestconfDocumentedException e) {
                        LOG.error("Error call http Patch operation {} on target {}", (Object)operation, (Object)patchEntity.getTargetNode().toString());
                        editErrors = new ArrayList();
                        editErrors.addAll(e.getErrors());
                        editCollection.add(new PatchStatusEntity(patchEntity.getEditId(), false, editErrors));
                        withoutError = false;
                    }
                    continue block14;
                }
            }
            LOG.error("Unsupported http Patch operation {} on target {}", (Object)operation, (Object)patchEntity.getTargetNode().toString());
        }
        if (!withoutError) {
            patchTransaction.cancel();
            return new PatchStatusContext(patchContext.getPatchId(), (List)ImmutableList.copyOf(editCollection), false, null);
        }
        final CountDownLatch waiter = new CountDownLatch(1);
        FluentFuture future = patchTransaction.commit();
        final PatchStatusContextHelper status = new PatchStatusContextHelper();
        future.addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                status.setStatus(new PatchStatusContext(patchContext.getPatchId(), (List)ImmutableList.copyOf((Collection)editCollection), true, null));
                waiter.countDown();
            }

            public void onFailure(Throwable throwable) {
                LOG.error("Http Patch {} transaction commit has failed", (Object)patchContext.getPatchId());
                status.setStatus(new PatchStatusContext(patchContext.getPatchId(), (List)ImmutableList.copyOf((Collection)editCollection), false, (List)ImmutableList.of((Object)new RestconfError(RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.OPERATION_FAILED, throwable.getMessage(), null, throwable.getCause().getMessage()))));
                waiter.countDown();
            }
        }, MoreExecutors.directExecutor());
        waiter.await();
        return status.getStatus();
    }

    public FluentFuture<? extends CommitInfo> commitConfigurationDataPost(SchemaContext globalSchema, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, String insert, String point) {
        return this.postDataViaTransaction(this.domDataBroker.newReadWriteTransaction(), LogicalDatastoreType.CONFIGURATION, path, payload, globalSchema, insert, point);
    }

    public FluentFuture<? extends CommitInfo> commitConfigurationDataPost(DOMMountPoint mountPoint, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, String insert, String point) {
        Optional domDataBrokerService = mountPoint.getService(DOMDataBroker.class);
        if (domDataBrokerService.isPresent()) {
            return this.postDataViaTransaction(((DOMDataBroker)domDataBrokerService.get()).newReadWriteTransaction(), LogicalDatastoreType.CONFIGURATION, path, payload, mountPoint.getSchemaContext(), insert, point);
        }
        throw BrokerFacade.dataBrokerUnavailable(path);
    }

    public FluentFuture<? extends CommitInfo> commitConfigurationDataDelete(YangInstanceIdentifier path) {
        return BrokerFacade.deleteDataViaTransaction(this.domDataBroker.newReadWriteTransaction(), LogicalDatastoreType.CONFIGURATION, path);
    }

    public FluentFuture<? extends CommitInfo> commitConfigurationDataDelete(DOMMountPoint mountPoint, YangInstanceIdentifier path) {
        Optional domDataBrokerService = mountPoint.getService(DOMDataBroker.class);
        if (domDataBrokerService.isPresent()) {
            return BrokerFacade.deleteDataViaTransaction(((DOMDataBroker)domDataBrokerService.get()).newReadWriteTransaction(), LogicalDatastoreType.CONFIGURATION, path);
        }
        throw BrokerFacade.dataBrokerUnavailable(path);
    }

    public FluentFuture<DOMRpcResult> invokeRpc(SchemaPath type, NormalizedNode<?, ?> input) {
        if (this.rpcService == null) {
            throw new RestconfDocumentedException(Response.Status.SERVICE_UNAVAILABLE);
        }
        LOG.trace("Invoke RPC {} with input: {}", (Object)type, input);
        return this.rpcService.invokeRpc(type, input);
    }

    public void registerToListenDataChanges(LogicalDatastoreType datastore, DataChangeScope scope, ListenerAdapter listener) {
        if (listener.isListening()) {
            return;
        }
        YangInstanceIdentifier path = listener.getPath();
        DOMDataTreeChangeService changeService = (DOMDataTreeChangeService)this.domDataBroker.getExtensions().getInstance(DOMDataTreeChangeService.class);
        if (changeService == null) {
            throw new UnsupportedOperationException("DOMDataBroker does not support the DOMDataTreeChangeService" + this.domDataBroker);
        }
        DOMDataTreeIdentifier root = new DOMDataTreeIdentifier(datastore, path);
        ListenerRegistration registration = changeService.registerDataTreeChangeListener(root, (DOMDataTreeChangeListener)listener);
        listener.setRegistration(registration);
    }

    private NormalizedNode<?, ?> readDataViaTransaction(DOMDataTreeReadTransaction transaction, LogicalDatastoreType datastore, YangInstanceIdentifier path) {
        return this.readDataViaTransaction(transaction, datastore, path, null);
    }

    private NormalizedNode<?, ?> readDataViaTransaction(DOMDataTreeReadTransaction transaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, String withDefa) {
        LOG.trace("Read {} via Restconf: {}", (Object)datastore.name(), (Object)path);
        try {
            Optional optional = (Optional)transaction.read(datastore, path).get();
            return !optional.isPresent() ? null : (withDefa == null ? (NormalizedNode<?, ?>)optional.get() : this.prepareDataByParamWithDef((NormalizedNode)optional.get(), path, withDefa));
        }
        catch (InterruptedException e) {
            LOG.warn("Error reading {} from datastore {}", new Object[]{path, datastore.name(), e});
            throw new RestconfDocumentedException("Error reading data.", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.warn("Error reading {} from datastore {}", new Object[]{path, datastore.name(), e});
            throw RestconfDocumentedException.decodeAndThrow((String)"Error reading data.", (OperationFailedException)((OperationFailedException)Throwables.getCauseAs((Throwable)e, ReadFailedException.class)));
        }
    }

    private NormalizedNode<?, ?> prepareDataByParamWithDef(NormalizedNode<?, ?> result, YangInstanceIdentifier path, String withDefa) {
        boolean trim;
        switch (withDefa) {
            case "trim": {
                trim = true;
                break;
            }
            case "explicit": {
                trim = false;
                break;
            }
            default: {
                throw new RestconfDocumentedException("Bad value used with with-defaults parameter : " + withDefa);
            }
        }
        SchemaContext ctx = this.controllerContext.getGlobalSchema();
        DataSchemaContextTree baseSchemaCtxTree = DataSchemaContextTree.from((SchemaContext)ctx);
        DataSchemaNode baseSchemaNode = baseSchemaCtxTree.getChild(path).getDataSchemaNode();
        if (result instanceof ContainerNode) {
            DataContainerNodeAttrBuilder builder = Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)baseSchemaNode));
            this.buildCont((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode>)builder, (ContainerNode)result, baseSchemaCtxTree, path, trim);
            return builder.build();
        }
        DataContainerNodeAttrBuilder builder = Builders.mapEntryBuilder((ListSchemaNode)((ListSchemaNode)baseSchemaNode));
        this.buildMapEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)builder, (MapEntryNode)result, baseSchemaCtxTree, path, trim, ((ListSchemaNode)baseSchemaNode).getKeyDefinition());
        return builder.build();
    }

    private void buildMapEntryBuilder(DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> builder, MapEntryNode result, DataSchemaContextTree baseSchemaCtxTree, YangInstanceIdentifier actualPath, boolean trim, List<QName> keys) {
        for (DataContainerChild child : result.getValue()) {
            DataContainerNodeAttrBuilder childBuilder;
            YangInstanceIdentifier path = actualPath.node(child.getIdentifier());
            DataSchemaNode childSchema = baseSchemaCtxTree.getChild(path).getDataSchemaNode();
            if (child instanceof ContainerNode) {
                childBuilder = Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)childSchema));
                this.buildCont((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode>)childBuilder, (ContainerNode)child, baseSchemaCtxTree, path, trim);
                builder.withChild((DataContainerChild)childBuilder.build());
                continue;
            }
            if (child instanceof MapNode) {
                childBuilder = Builders.mapBuilder((ListSchemaNode)((ListSchemaNode)childSchema));
                this.buildList((CollectionNodeBuilder<MapEntryNode, MapNode>)childBuilder, (MapNode)child, baseSchemaCtxTree, path, trim, ((ListSchemaNode)childSchema).getKeyDefinition());
                builder.withChild((DataContainerChild)childBuilder.build());
                continue;
            }
            if (!(child instanceof LeafNode)) continue;
            Object defaultVal = ((LeafSchemaNode)childSchema).getType().getDefaultValue().orElse(null);
            Object nodeVal = child.getValue();
            NormalizedNodeAttrBuilder leafBuilder = Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)childSchema));
            if (keys.contains(child.getNodeType())) {
                leafBuilder.withValue(child.getValue());
                builder.withChild((DataContainerChild)leafBuilder.build());
                continue;
            }
            if (trim) {
                if (defaultVal != null && defaultVal.equals(nodeVal)) continue;
                leafBuilder.withValue(child.getValue());
                builder.withChild((DataContainerChild)leafBuilder.build());
                continue;
            }
            if (defaultVal == null || !defaultVal.equals(nodeVal)) continue;
            leafBuilder.withValue(child.getValue());
            builder.withChild((DataContainerChild)leafBuilder.build());
        }
    }

    private void buildList(CollectionNodeBuilder<MapEntryNode, MapNode> builder, MapNode result, DataSchemaContextTree baseSchemaCtxTree, YangInstanceIdentifier path, boolean trim, List<QName> keys) {
        for (MapEntryNode mapEntryNode : result.getValue()) {
            YangInstanceIdentifier actualNode = path.node((YangInstanceIdentifier.PathArgument)mapEntryNode.getIdentifier());
            DataSchemaNode childSchema = baseSchemaCtxTree.getChild(actualNode).getDataSchemaNode();
            DataContainerNodeAttrBuilder mapEntryBuilder = Builders.mapEntryBuilder((ListSchemaNode)((ListSchemaNode)childSchema));
            this.buildMapEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)mapEntryBuilder, mapEntryNode, baseSchemaCtxTree, actualNode, trim, keys);
            builder.withChild(mapEntryBuilder.build());
        }
    }

    private void buildCont(DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> builder, ContainerNode result, DataSchemaContextTree baseSchemaCtxTree, YangInstanceIdentifier actualPath, boolean trim) {
        for (DataContainerChild child : result.getValue()) {
            YangInstanceIdentifier path = actualPath.node(child.getIdentifier());
            DataSchemaNode childSchema = baseSchemaCtxTree.getChild(path).getDataSchemaNode();
            if (child instanceof ContainerNode) {
                DataContainerNodeAttrBuilder builderChild = Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)childSchema));
                this.buildCont((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode>)builderChild, result, baseSchemaCtxTree, actualPath, trim);
                builder.withChild((DataContainerChild)builderChild.build());
                continue;
            }
            if (child instanceof MapNode) {
                CollectionNodeBuilder childBuilder = Builders.mapBuilder((ListSchemaNode)((ListSchemaNode)childSchema));
                this.buildList((CollectionNodeBuilder<MapEntryNode, MapNode>)childBuilder, (MapNode)child, baseSchemaCtxTree, path, trim, ((ListSchemaNode)childSchema).getKeyDefinition());
                builder.withChild((DataContainerChild)childBuilder.build());
                continue;
            }
            if (!(child instanceof LeafNode)) continue;
            Object defaultVal = ((LeafSchemaNode)childSchema).getType().getDefaultValue().orElse(null);
            Object nodeVal = child.getValue();
            NormalizedNodeAttrBuilder leafBuilder = Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)childSchema));
            if (trim) {
                if (defaultVal != null && defaultVal.equals(nodeVal)) continue;
                leafBuilder.withValue(child.getValue());
                builder.withChild((DataContainerChild)leafBuilder.build());
                continue;
            }
            if (defaultVal == null || !defaultVal.equals(nodeVal)) continue;
            leafBuilder.withValue(child.getValue());
            builder.withChild((DataContainerChild)leafBuilder.build());
        }
    }

    private FluentFuture<? extends CommitInfo> postDataViaTransaction(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext, String insert, String point) {
        LOG.trace("POST {} via Restconf: {} with payload {}", new Object[]{datastore.name(), path, payload});
        this.postData(rwTransaction, datastore, path, payload, schemaContext, insert, point);
        return rwTransaction.commit();
    }

    private void postDataWithinTransaction(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext) {
        LOG.trace("POST {} within Restconf Patch: {} with payload {}", new Object[]{datastore.name(), path, payload});
        this.postData(rwTransaction, datastore, path, payload, schemaContext, null, null);
    }

    private void postData(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext, String insert, String point) {
        if (insert == null) {
            BrokerFacade.makeNormalPost(rwTransaction, datastore, path, payload, schemaContext);
            return;
        }
        DataSchemaNode schemaNode = BrokerFacade.checkListAndOrderedType(schemaContext, path);
        BrokerFacade.checkItemDoesNotExists(rwTransaction, datastore, path);
        switch (insert) {
            case "first": {
                if (schemaNode instanceof ListSchemaNode) {
                    OrderedMapNode readList = (OrderedMapNode)this.readConfigurationData(path.getParent().getParent());
                    if (readList == null || readList.getValue().isEmpty()) {
                        BrokerFacade.simplePostPut(rwTransaction, datastore, path, payload, schemaContext);
                        break;
                    }
                    rwTransaction.delete(datastore, path.getParent().getParent());
                    BrokerFacade.simplePostPut(rwTransaction, datastore, path, payload, schemaContext);
                    BrokerFacade.makeNormalPost(rwTransaction, datastore, path.getParent().getParent(), readList, schemaContext);
                    break;
                }
                OrderedLeafSetNode readLeafList = (OrderedLeafSetNode)this.readConfigurationData(path.getParent());
                if (readLeafList == null || readLeafList.getValue().isEmpty()) {
                    BrokerFacade.simplePostPut(rwTransaction, datastore, path, payload, schemaContext);
                    break;
                }
                rwTransaction.delete(datastore, path.getParent());
                BrokerFacade.simplePostPut(rwTransaction, datastore, path, payload, schemaContext);
                BrokerFacade.makeNormalPost(rwTransaction, datastore, path.getParent().getParent(), readLeafList, schemaContext);
                break;
            }
            case "last": {
                BrokerFacade.simplePostPut(rwTransaction, datastore, path, payload, schemaContext);
                break;
            }
            case "before": {
                if (schemaNode instanceof ListSchemaNode) {
                    OrderedMapNode readList = (OrderedMapNode)this.readConfigurationData(path.getParent().getParent());
                    if (readList == null || readList.getValue().isEmpty()) {
                        BrokerFacade.simplePostPut(rwTransaction, datastore, path, payload, schemaContext);
                        break;
                    }
                    this.insertWithPointListPost(rwTransaction, datastore, path, payload, schemaContext, point, (MapNode)readList, true);
                    break;
                }
                OrderedLeafSetNode readLeafList = (OrderedLeafSetNode)this.readConfigurationData(path.getParent());
                if (readLeafList == null || readLeafList.getValue().isEmpty()) {
                    BrokerFacade.simplePostPut(rwTransaction, datastore, path, payload, schemaContext);
                    break;
                }
                this.insertWithPointLeafListPost(rwTransaction, datastore, path, payload, schemaContext, point, readLeafList, true);
                break;
            }
            case "after": {
                if (schemaNode instanceof ListSchemaNode) {
                    OrderedMapNode readList = (OrderedMapNode)this.readConfigurationData(path.getParent().getParent());
                    if (readList == null || readList.getValue().isEmpty()) {
                        BrokerFacade.simplePostPut(rwTransaction, datastore, path, payload, schemaContext);
                        break;
                    }
                    this.insertWithPointListPost(rwTransaction, datastore, path, payload, schemaContext, point, (MapNode)readList, false);
                    break;
                }
                OrderedLeafSetNode readLeafList = (OrderedLeafSetNode)this.readConfigurationData(path.getParent());
                if (readLeafList == null || readLeafList.getValue().isEmpty()) {
                    BrokerFacade.simplePostPut(rwTransaction, datastore, path, payload, schemaContext);
                    break;
                }
                this.insertWithPointLeafListPost(rwTransaction, datastore, path, payload, schemaContext, point, readLeafList, false);
                break;
            }
            default: {
                throw new RestconfDocumentedException("Used bad value of insert parameter. Possible values are first, last, before or after, but was: " + insert);
            }
        }
    }

    private void insertWithPointLeafListPost(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext, String point, OrderedLeafSetNode<?> readLeafList, boolean before) {
        LeafSetEntryNode nodeChild;
        rwTransaction.delete(datastore, path.getParent().getParent());
        InstanceIdentifierContext<?> instanceIdentifier = this.controllerContext.toInstanceIdentifier(point);
        int lastItemPosition = 0;
        Iterator iterator = readLeafList.getValue().iterator();
        while (iterator.hasNext() && !(nodeChild = (LeafSetEntryNode)iterator.next()).getIdentifier().equals((Object)instanceIdentifier.getInstanceIdentifier().getLastPathArgument())) {
            ++lastItemPosition;
        }
        if (!before) {
            ++lastItemPosition;
        }
        int lastInsertedPosition = 0;
        NormalizedNode emptySubtree = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)path.getParent().getParent());
        rwTransaction.merge(datastore, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubtree.getIdentifier()}), emptySubtree);
        for (LeafSetEntryNode nodeChild2 : readLeafList.getValue()) {
            if (lastInsertedPosition == lastItemPosition) {
                BrokerFacade.checkItemDoesNotExists(rwTransaction, datastore, path);
                BrokerFacade.simplePostPut(rwTransaction, datastore, path, payload, schemaContext);
            }
            YangInstanceIdentifier childPath = path.getParent().getParent().node((YangInstanceIdentifier.PathArgument)nodeChild2.getIdentifier());
            BrokerFacade.checkItemDoesNotExists(rwTransaction, datastore, childPath);
            rwTransaction.put(datastore, childPath, (NormalizedNode)nodeChild2);
            ++lastInsertedPosition;
        }
    }

    private void insertWithPointListPost(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext, String point, MapNode readList, boolean before) {
        MapEntryNode mapEntryNode;
        rwTransaction.delete(datastore, path.getParent().getParent());
        InstanceIdentifierContext<?> instanceIdentifier = this.controllerContext.toInstanceIdentifier(point);
        int lastItemPosition = 0;
        Iterator iterator = readList.getValue().iterator();
        while (iterator.hasNext() && !(mapEntryNode = (MapEntryNode)iterator.next()).getIdentifier().equals((Object)instanceIdentifier.getInstanceIdentifier().getLastPathArgument())) {
            ++lastItemPosition;
        }
        if (!before) {
            ++lastItemPosition;
        }
        int lastInsertedPosition = 0;
        NormalizedNode emptySubtree = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)path.getParent().getParent());
        rwTransaction.merge(datastore, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubtree.getIdentifier()}), emptySubtree);
        for (MapEntryNode mapEntryNode2 : readList.getValue()) {
            if (lastInsertedPosition == lastItemPosition) {
                BrokerFacade.checkItemDoesNotExists(rwTransaction, datastore, path);
                BrokerFacade.simplePostPut(rwTransaction, datastore, path, payload, schemaContext);
            }
            YangInstanceIdentifier childPath = path.getParent().getParent().node((YangInstanceIdentifier.PathArgument)mapEntryNode2.getIdentifier());
            BrokerFacade.checkItemDoesNotExists(rwTransaction, datastore, childPath);
            rwTransaction.put(datastore, childPath, (NormalizedNode)mapEntryNode2);
            ++lastInsertedPosition;
        }
    }

    private static DataSchemaNode checkListAndOrderedType(SchemaContext ctx, YangInstanceIdentifier path) {
        YangInstanceIdentifier parent = path.getParent();
        DataSchemaContextNode node = DataSchemaContextTree.from((SchemaContext)ctx).getChild(parent);
        DataSchemaNode dataSchemaNode = node.getDataSchemaNode();
        if (dataSchemaNode instanceof ListSchemaNode) {
            if (!((ListSchemaNode)dataSchemaNode).isUserOrdered()) {
                throw new RestconfDocumentedException("Insert parameter can be used only with ordered-by user list.");
            }
            return dataSchemaNode;
        }
        if (dataSchemaNode instanceof LeafListSchemaNode) {
            if (!((LeafListSchemaNode)dataSchemaNode).isUserOrdered()) {
                throw new RestconfDocumentedException("Insert parameter can be used only with ordered-by user leaf-list.");
            }
            return dataSchemaNode;
        }
        throw new RestconfDocumentedException("Insert parameter can be used only with list or leaf-list");
    }

    private static void makeNormalPost(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext) {
        Map.Entry<YangInstanceIdentifier, ReadFailedException> failure;
        Collection children;
        if (payload instanceof MapNode) {
            children = ((MapNode)payload).getValue();
        } else if (payload instanceof LeafSetNode) {
            children = ((LeafSetNode)payload).getValue();
        } else {
            BrokerFacade.simplePostPut(rwTransaction, datastore, path, payload, schemaContext);
            return;
        }
        NormalizedNode emptySubtree = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)path);
        if (children.isEmpty()) {
            rwTransaction.merge(datastore, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubtree.getIdentifier()}), emptySubtree);
            BrokerFacade.ensureParentsByMerge(datastore, path, (DOMDataTreeWriteTransaction)rwTransaction, schemaContext);
            return;
        }
        BatchedExistenceCheck check = BatchedExistenceCheck.start((DOMDataTreeReadTransaction)rwTransaction, datastore, path, children);
        rwTransaction.merge(datastore, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubtree.getIdentifier()}), emptySubtree);
        BrokerFacade.ensureParentsByMerge(datastore, path, (DOMDataTreeWriteTransaction)rwTransaction, schemaContext);
        for (NormalizedNode child : children) {
            rwTransaction.put(datastore, path.node(child.getIdentifier()), child);
        }
        try {
            failure = check.getFailure();
        }
        catch (InterruptedException e) {
            rwTransaction.cancel();
            throw new RestconfDocumentedException("Could not determine the existence of path " + path, (Throwable)e);
        }
        if (failure != null) {
            rwTransaction.cancel();
            ReadFailedException e = failure.getValue();
            if (e == null) {
                throw new RestconfDocumentedException("Data already exists for path: " + failure.getKey(), RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.DATA_EXISTS);
            }
            throw new RestconfDocumentedException("Could not determine the existence of path " + failure.getKey(), (Throwable)e, (Collection)e.getErrorList());
        }
    }

    private static void simplePostPut(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext) {
        BrokerFacade.checkItemDoesNotExists(rwTransaction, datastore, path);
        BrokerFacade.ensureParentsByMerge(datastore, path, (DOMDataTreeWriteTransaction)rwTransaction, schemaContext);
        rwTransaction.put(datastore, path, payload);
    }

    private static boolean doesItemExist(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType store, YangInstanceIdentifier path) {
        try {
            return (Boolean)rwTransaction.exists(store, path).get();
        }
        catch (InterruptedException e) {
            rwTransaction.cancel();
            throw new RestconfDocumentedException("Could not determine the existence of path " + path, (Throwable)e);
        }
        catch (ExecutionException e) {
            rwTransaction.cancel();
            throw RestconfDocumentedException.decodeAndThrow((String)("Could not determine the existence of path " + path), (OperationFailedException)((OperationFailedException)Throwables.getCauseAs((Throwable)e, ReadFailedException.class)));
        }
    }

    private static void checkItemExists(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType store, YangInstanceIdentifier path) {
        if (!BrokerFacade.doesItemExist(rwTransaction, store, path)) {
            LOG.trace("Operation via Restconf was not executed because data at {} does not exist", (Object)path);
            rwTransaction.cancel();
            throw new RestconfDocumentedException("Data does not exist for path: " + path, RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.DATA_MISSING);
        }
    }

    private static void checkItemDoesNotExists(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType store, YangInstanceIdentifier path) {
        if (BrokerFacade.doesItemExist(rwTransaction, store, path)) {
            LOG.trace("Operation via Restconf was not executed because data at {} already exists", (Object)path);
            rwTransaction.cancel();
            throw new RestconfDocumentedException("Data already exists for path: " + path, RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.DATA_EXISTS);
        }
    }

    private FluentFuture<? extends CommitInfo> putDataViaTransaction(DOMDataTreeReadWriteTransaction readWriteTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext, String insert, String point) {
        LOG.trace("Put {} via Restconf: {} with payload {}", new Object[]{datastore.name(), path, payload});
        this.putData(readWriteTransaction, datastore, path, payload, schemaContext, insert, point);
        return readWriteTransaction.commit();
    }

    private void putDataWithinTransaction(DOMDataTreeReadWriteTransaction writeTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext) {
        LOG.trace("Put {} within Restconf Patch: {} with payload {}", new Object[]{datastore.name(), path, payload});
        this.putData(writeTransaction, datastore, path, payload, schemaContext, null, null);
    }

    private void putData(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext, String insert, String point) {
        if (insert == null) {
            BrokerFacade.makePut((DOMDataTreeWriteTransaction)rwTransaction, datastore, path, payload, schemaContext);
            return;
        }
        DataSchemaNode schemaNode = BrokerFacade.checkListAndOrderedType(schemaContext, path);
        BrokerFacade.checkItemDoesNotExists(rwTransaction, datastore, path);
        switch (insert) {
            case "first": {
                if (schemaNode instanceof ListSchemaNode) {
                    OrderedMapNode readList = (OrderedMapNode)this.readConfigurationData(path.getParent());
                    if (readList == null || readList.getValue().isEmpty()) {
                        BrokerFacade.simplePut(datastore, path, (DOMDataTreeWriteTransaction)rwTransaction, schemaContext, payload);
                        break;
                    }
                    rwTransaction.delete(datastore, path.getParent());
                    BrokerFacade.simplePut(datastore, path, (DOMDataTreeWriteTransaction)rwTransaction, schemaContext, payload);
                    BrokerFacade.makePut((DOMDataTreeWriteTransaction)rwTransaction, datastore, path.getParent(), readList, schemaContext);
                    break;
                }
                OrderedLeafSetNode readLeafList = (OrderedLeafSetNode)this.readConfigurationData(path.getParent());
                if (readLeafList == null || readLeafList.getValue().isEmpty()) {
                    BrokerFacade.simplePut(datastore, path, (DOMDataTreeWriteTransaction)rwTransaction, schemaContext, payload);
                    break;
                }
                rwTransaction.delete(datastore, path.getParent());
                BrokerFacade.simplePut(datastore, path, (DOMDataTreeWriteTransaction)rwTransaction, schemaContext, payload);
                BrokerFacade.makePut((DOMDataTreeWriteTransaction)rwTransaction, datastore, path.getParent(), readLeafList, schemaContext);
                break;
            }
            case "last": {
                BrokerFacade.simplePut(datastore, path, (DOMDataTreeWriteTransaction)rwTransaction, schemaContext, payload);
                break;
            }
            case "before": {
                if (schemaNode instanceof ListSchemaNode) {
                    OrderedMapNode readList = (OrderedMapNode)this.readConfigurationData(path.getParent());
                    if (readList == null || readList.getValue().isEmpty()) {
                        BrokerFacade.simplePut(datastore, path, (DOMDataTreeWriteTransaction)rwTransaction, schemaContext, payload);
                        break;
                    }
                    this.insertWithPointListPut((DOMDataTreeWriteTransaction)rwTransaction, datastore, path, payload, schemaContext, point, readList, true);
                    break;
                }
                OrderedLeafSetNode readLeafList = (OrderedLeafSetNode)this.readConfigurationData(path.getParent());
                if (readLeafList == null || readLeafList.getValue().isEmpty()) {
                    BrokerFacade.simplePut(datastore, path, (DOMDataTreeWriteTransaction)rwTransaction, schemaContext, payload);
                    break;
                }
                this.insertWithPointLeafListPut((DOMDataTreeWriteTransaction)rwTransaction, datastore, path, payload, schemaContext, point, readLeafList, true);
                break;
            }
            case "after": {
                if (schemaNode instanceof ListSchemaNode) {
                    OrderedMapNode readList = (OrderedMapNode)this.readConfigurationData(path.getParent());
                    if (readList == null || readList.getValue().isEmpty()) {
                        BrokerFacade.simplePut(datastore, path, (DOMDataTreeWriteTransaction)rwTransaction, schemaContext, payload);
                        break;
                    }
                    this.insertWithPointListPut((DOMDataTreeWriteTransaction)rwTransaction, datastore, path, payload, schemaContext, point, readList, false);
                    break;
                }
                OrderedLeafSetNode readLeafList = (OrderedLeafSetNode)this.readConfigurationData(path.getParent());
                if (readLeafList == null || readLeafList.getValue().isEmpty()) {
                    BrokerFacade.simplePut(datastore, path, (DOMDataTreeWriteTransaction)rwTransaction, schemaContext, payload);
                    break;
                }
                this.insertWithPointLeafListPut((DOMDataTreeWriteTransaction)rwTransaction, datastore, path, payload, schemaContext, point, readLeafList, false);
                break;
            }
            default: {
                throw new RestconfDocumentedException("Used bad value of insert parameter. Possible values are first, last, before or after, but was: " + insert);
            }
        }
    }

    private void insertWithPointLeafListPut(DOMDataTreeWriteTransaction tx, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext, String point, OrderedLeafSetNode<?> readLeafList, boolean before) {
        LeafSetEntryNode nodeChild;
        tx.delete(datastore, path.getParent());
        InstanceIdentifierContext<?> instanceIdentifier = this.controllerContext.toInstanceIdentifier(point);
        int index1 = 0;
        Iterator iterator = readLeafList.getValue().iterator();
        while (iterator.hasNext() && !(nodeChild = (LeafSetEntryNode)iterator.next()).getIdentifier().equals((Object)instanceIdentifier.getInstanceIdentifier().getLastPathArgument())) {
            ++index1;
        }
        if (!before) {
            ++index1;
        }
        int index2 = 0;
        NormalizedNode emptySubtree = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)path.getParent());
        tx.merge(datastore, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubtree.getIdentifier()}), emptySubtree);
        for (LeafSetEntryNode nodeChild2 : readLeafList.getValue()) {
            if (index2 == index1) {
                BrokerFacade.simplePut(datastore, path, tx, schemaContext, payload);
            }
            YangInstanceIdentifier childPath = path.getParent().node((YangInstanceIdentifier.PathArgument)nodeChild2.getIdentifier());
            tx.put(datastore, childPath, (NormalizedNode)nodeChild2);
            ++index2;
        }
    }

    private void insertWithPointListPut(DOMDataTreeWriteTransaction tx, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext, String point, OrderedMapNode readList, boolean before) {
        MapEntryNode mapEntryNode;
        tx.delete(datastore, path.getParent());
        InstanceIdentifierContext<?> instanceIdentifier = this.controllerContext.toInstanceIdentifier(point);
        int index1 = 0;
        Iterator iterator = readList.getValue().iterator();
        while (iterator.hasNext() && !(mapEntryNode = (MapEntryNode)iterator.next()).getIdentifier().equals((Object)instanceIdentifier.getInstanceIdentifier().getLastPathArgument())) {
            ++index1;
        }
        if (!before) {
            ++index1;
        }
        int index2 = 0;
        NormalizedNode emptySubtree = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)path.getParent());
        tx.merge(datastore, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubtree.getIdentifier()}), emptySubtree);
        for (MapEntryNode mapEntryNode2 : readList.getValue()) {
            if (index2 == index1) {
                BrokerFacade.simplePut(datastore, path, tx, schemaContext, payload);
            }
            YangInstanceIdentifier childPath = path.getParent().node((YangInstanceIdentifier.PathArgument)mapEntryNode2.getIdentifier());
            tx.put(datastore, childPath, (NormalizedNode)mapEntryNode2);
            ++index2;
        }
    }

    private static void makePut(DOMDataTreeWriteTransaction tx, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext) {
        if (payload instanceof MapNode) {
            NormalizedNode emptySubtree = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)path);
            tx.merge(datastore, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubtree.getIdentifier()}), emptySubtree);
            BrokerFacade.ensureParentsByMerge(datastore, path, tx, schemaContext);
            for (MapEntryNode child : ((MapNode)payload).getValue()) {
                YangInstanceIdentifier childPath = path.node((YangInstanceIdentifier.PathArgument)child.getIdentifier());
                tx.put(datastore, childPath, (NormalizedNode)child);
            }
        } else {
            BrokerFacade.simplePut(datastore, path, tx, schemaContext, payload);
        }
    }

    private static void simplePut(LogicalDatastoreType datastore, YangInstanceIdentifier path, DOMDataTreeWriteTransaction tx, SchemaContext schemaContext, NormalizedNode<?, ?> payload) {
        BrokerFacade.ensureParentsByMerge(datastore, path, tx, schemaContext);
        tx.put(datastore, path, payload);
    }

    private static FluentFuture<? extends CommitInfo> deleteDataViaTransaction(DOMDataTreeReadWriteTransaction readWriteTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path) {
        LOG.trace("Delete {} via Restconf: {}", (Object)datastore.name(), (Object)path);
        BrokerFacade.checkItemExists(readWriteTransaction, datastore, path);
        readWriteTransaction.delete(datastore, path);
        return readWriteTransaction.commit();
    }

    private static void deleteDataWithinTransaction(DOMDataTreeWriteTransaction tx, LogicalDatastoreType datastore, YangInstanceIdentifier path) {
        LOG.trace("Delete {} within Restconf Patch: {}", (Object)datastore.name(), (Object)path);
        tx.delete(datastore, path);
    }

    private static void mergeDataWithinTransaction(DOMDataTreeWriteTransaction tx, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext) {
        LOG.trace("Merge {} within Restconf Patch: {} with payload {}", new Object[]{datastore.name(), path, payload});
        BrokerFacade.ensureParentsByMerge(datastore, path, tx, schemaContext);
        tx.merge(datastore, path, payload);
    }

    public void registerToListenNotification(NotificationListenerAdapter listener) {
        if (listener.isListening()) {
            return;
        }
        SchemaPath path = listener.getSchemaPath();
        ListenerRegistration registration = this.domNotification.registerNotificationListener((DOMNotificationListener)listener, new SchemaPath[]{path});
        listener.setRegistration(registration);
    }

    private static void ensureParentsByMerge(LogicalDatastoreType store, YangInstanceIdentifier normalizedPath, DOMDataTreeWriteTransaction tx, SchemaContext schemaContext) {
        ArrayList<YangInstanceIdentifier.PathArgument> normalizedPathWithoutChildArgs = new ArrayList<YangInstanceIdentifier.PathArgument>();
        YangInstanceIdentifier rootNormalizedPath = null;
        Iterator it = normalizedPath.getPathArguments().iterator();
        while (it.hasNext()) {
            YangInstanceIdentifier.PathArgument pathArgument = (YangInstanceIdentifier.PathArgument)it.next();
            if (rootNormalizedPath == null) {
                rootNormalizedPath = YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{pathArgument});
            }
            if (!it.hasNext()) continue;
            normalizedPathWithoutChildArgs.add(pathArgument);
        }
        if (normalizedPathWithoutChildArgs.isEmpty()) {
            return;
        }
        Preconditions.checkArgument((rootNormalizedPath != null ? 1 : 0) != 0, (Object)"Empty path received");
        NormalizedNode parentStructure = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)YangInstanceIdentifier.create(normalizedPathWithoutChildArgs));
        tx.merge(store, rootNormalizedPath, parentStructure);
    }

    private static RestconfDocumentedException dataBrokerUnavailable(YangInstanceIdentifier path) {
        LOG.warn("DOM data broker service is not available for mount point {}", (Object)path);
        return new RestconfDocumentedException("DOM data broker service is not available for mount point " + path);
    }

    private static final class PatchStatusContextHelper {
        PatchStatusContext status;

        private PatchStatusContextHelper() {
        }

        public PatchStatusContext getStatus() {
            return this.status;
        }

        public void setStatus(PatchStatusContext status) {
            this.status = status;
        }
    }
}

