/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.rest.impl;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.opendaylight.netconf.md.sal.rest.schema.SchemaExportContentYangBodyWriter;
import org.opendaylight.netconf.md.sal.rest.schema.SchemaExportContentYinBodyWriter;
import org.opendaylight.netconf.md.sal.rest.schema.SchemaRetrievalServiceImpl;
import org.opendaylight.netconf.sal.rest.impl.JsonNormalizedNodeBodyReader;
import org.opendaylight.netconf.sal.rest.impl.JsonToPatchBodyReader;
import org.opendaylight.netconf.sal.rest.impl.NormalizedNodeJsonBodyWriter;
import org.opendaylight.netconf.sal.rest.impl.NormalizedNodeXmlBodyWriter;
import org.opendaylight.netconf.sal.rest.impl.PatchJsonBodyWriter;
import org.opendaylight.netconf.sal.rest.impl.PatchXmlBodyWriter;
import org.opendaylight.netconf.sal.rest.impl.RestconfCompositeWrapper;
import org.opendaylight.netconf.sal.rest.impl.RestconfDocumentedExceptionMapper;
import org.opendaylight.netconf.sal.rest.impl.XmlNormalizedNodeBodyReader;
import org.opendaylight.netconf.sal.rest.impl.XmlToPatchBodyReader;
import org.opendaylight.netconf.sal.restconf.impl.ControllerContext;
import org.opendaylight.netconf.sal.restconf.impl.StatisticsRestconfServiceWrapper;

public class RestconfApplication
extends Application {
    private final ControllerContext controllerContext;
    private final StatisticsRestconfServiceWrapper statsServiceWrapper;

    public RestconfApplication(ControllerContext controllerContext, StatisticsRestconfServiceWrapper statsServiceWrapper) {
        this.controllerContext = controllerContext;
        this.statsServiceWrapper = statsServiceWrapper;
    }

    public Set<Class<?>> getClasses() {
        return ImmutableSet.builder().add(PatchJsonBodyWriter.class).add(PatchXmlBodyWriter.class).add(NormalizedNodeJsonBodyWriter.class).add(NormalizedNodeXmlBodyWriter.class).add(SchemaExportContentYinBodyWriter.class).add(SchemaExportContentYangBodyWriter.class).build();
    }

    public Set<Object> getSingletons() {
        HashSet<Object> singletons = new HashSet<Object>();
        SchemaRetrievalServiceImpl schemaRetrieval = new SchemaRetrievalServiceImpl(this.controllerContext);
        singletons.add(schemaRetrieval);
        singletons.add(new RestconfCompositeWrapper(this.statsServiceWrapper, schemaRetrieval));
        singletons.add(new RestconfDocumentedExceptionMapper(this.controllerContext));
        singletons.add(new XmlNormalizedNodeBodyReader(this.controllerContext));
        singletons.add(new JsonNormalizedNodeBodyReader(this.controllerContext));
        singletons.add(new XmlToPatchBodyReader(this.controllerContext));
        singletons.add(new JsonToPatchBodyReader(this.controllerContext));
        return singletons;
    }
}

