/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.rest.impl;

import com.google.common.collect.ImmutableList;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.opendaylight.netconf.sal.rest.impl.AbstractIdentifierAwareJaxRsProvider;
import org.opendaylight.netconf.sal.rest.impl.StringModuleInstanceIdentifierCodec;
import org.opendaylight.netconf.sal.restconf.impl.ControllerContext;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.patch.PatchContext;
import org.opendaylight.restconf.common.patch.PatchEditOperation;
import org.opendaylight.restconf.common.patch.PatchEntity;
import org.opendaylight.restconf.common.util.RestUtil;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.data.impl.schema.ResultAlreadySetException;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Provider
@Consumes(value={"application/yang.patch+json"})
public class JsonToPatchBodyReader
extends AbstractIdentifierAwareJaxRsProvider
implements MessageBodyReader<PatchContext> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonToPatchBodyReader.class);

    public JsonToPatchBodyReader(ControllerContext controllerContext) {
        super(controllerContext);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public PatchContext readFrom(Class<PatchContext> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException {
        try {
            return this.readFrom(this.getInstanceIdentifierContext(), entityStream);
        }
        catch (Exception e) {
            throw JsonToPatchBodyReader.propagateExceptionAs(e);
        }
    }

    public PatchContext readFrom(String uriPath, InputStream entityStream) throws RestconfDocumentedException {
        try {
            return this.readFrom(this.getControllerContext().toInstanceIdentifier(uriPath), entityStream);
        }
        catch (Exception e) {
            JsonToPatchBodyReader.propagateExceptionAs(e);
            return null;
        }
    }

    private PatchContext readFrom(InstanceIdentifierContext<?> path, InputStream entityStream) throws IOException {
        Optional nonEmptyInputStreamOptional = RestUtil.isInputStreamEmpty((InputStream)entityStream);
        if (!nonEmptyInputStreamOptional.isPresent()) {
            return new PatchContext(path, null, null);
        }
        JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)nonEmptyInputStreamOptional.get(), StandardCharsets.UTF_8));
        AtomicReference<String> patchId = new AtomicReference<String>();
        List<PatchEntity> resultList = this.read(jsonReader, path, patchId);
        jsonReader.close();
        return new PatchContext(path, resultList, patchId.get());
    }

    private static RuntimeException propagateExceptionAs(Exception exception) throws RestconfDocumentedException {
        if (exception instanceof RestconfDocumentedException) {
            throw (RestconfDocumentedException)exception;
        }
        if (exception instanceof ResultAlreadySetException) {
            LOG.debug("Error parsing json input:", (Throwable)exception);
            throw new RestconfDocumentedException("Error parsing json input: Failed to create new parse result data. ");
        }
        throw new RestconfDocumentedException("Error parsing json input: " + exception.getMessage(), RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE, (Throwable)exception);
    }

    private List<PatchEntity> read(JsonReader in, InstanceIdentifierContext<?> path, AtomicReference<String> patchId) throws IOException {
        ArrayList<PatchEntity> resultCollection = new ArrayList<PatchEntity>();
        StringModuleInstanceIdentifierCodec codec = new StringModuleInstanceIdentifierCodec(path.getSchemaContext());
        PatchEdit edit = new PatchEdit();
        block11: while (in.hasNext()) {
            switch (in.peek()) {
                case STRING: 
                case NUMBER: {
                    in.nextString();
                    continue block11;
                }
                case BOOLEAN: {
                    Boolean.toString(in.nextBoolean());
                    continue block11;
                }
                case NULL: {
                    in.nextNull();
                    continue block11;
                }
                case BEGIN_ARRAY: {
                    in.beginArray();
                    continue block11;
                }
                case BEGIN_OBJECT: {
                    in.beginObject();
                    continue block11;
                }
                case END_DOCUMENT: {
                    continue block11;
                }
                case NAME: {
                    this.parseByName(in.nextName(), edit, in, path, codec, resultCollection, patchId);
                    continue block11;
                }
                case END_OBJECT: {
                    in.endObject();
                    continue block11;
                }
                case END_ARRAY: {
                    in.endArray();
                    continue block11;
                }
            }
        }
        return ImmutableList.copyOf(resultCollection);
    }

    private void parseByName(@Nonnull String name, @Nonnull PatchEdit edit, @Nonnull JsonReader in, @Nonnull InstanceIdentifierContext<?> path, @Nonnull StringModuleInstanceIdentifierCodec codec, @Nonnull List<PatchEntity> resultCollection, @Nonnull AtomicReference<String> patchId) throws IOException {
        switch (name) {
            case "edit": {
                if (in.peek() == JsonToken.BEGIN_ARRAY) {
                    in.beginArray();
                    while (in.hasNext()) {
                        this.readEditDefinition(edit, in, path, codec);
                        resultCollection.add(JsonToPatchBodyReader.prepareEditOperation(edit));
                        edit.clear();
                    }
                    in.endArray();
                    break;
                }
                this.readEditDefinition(edit, in, path, codec);
                resultCollection.add(JsonToPatchBodyReader.prepareEditOperation(edit));
                edit.clear();
                break;
            }
            case "patch-id": {
                patchId.set(in.nextString());
                break;
            }
        }
    }

    private void readEditDefinition(@Nonnull PatchEdit edit, @Nonnull JsonReader in, @Nonnull InstanceIdentifierContext<?> path, @Nonnull StringModuleInstanceIdentifierCodec codec) throws IOException {
        StringBuffer value = new StringBuffer();
        in.beginObject();
        while (in.hasNext()) {
            String editDefinition;
            switch (editDefinition = in.nextName()) {
                case "edit-id": {
                    edit.setId(in.nextString());
                    break;
                }
                case "operation": {
                    edit.setOperation(PatchEditOperation.valueOf((String)in.nextString().toUpperCase(Locale.ROOT)));
                    break;
                }
                case "target": {
                    String target = in.nextString();
                    if (target.equals("/")) {
                        edit.setTarget(path.getInstanceIdentifier());
                        edit.setTargetSchemaNode((SchemaNode)path.getSchemaContext());
                        break;
                    }
                    edit.setTarget(codec.deserialize(codec.serialize(path.getInstanceIdentifier()).concat(target)));
                    edit.setTargetSchemaNode(SchemaContextUtil.findDataSchemaNode((SchemaContext)path.getSchemaContext(), (SchemaPath)codec.getDataContextTree().getChild(edit.getTarget()).getDataSchemaNode().getPath().getParent()));
                    break;
                }
                case "value": {
                    this.readValueNode(value, in);
                    break;
                }
            }
        }
        in.endObject();
        edit.setData(JsonToPatchBodyReader.readEditData(new JsonReader((Reader)new StringReader(value.toString())), edit.getTargetSchemaNode(), path));
    }

    private void readValueNode(@Nonnull StringBuffer value, @Nonnull JsonReader in) throws IOException {
        in.beginObject();
        value.append("{");
        value.append("\"" + in.nextName() + "\":");
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
            in.beginArray();
            value.append("[");
            while (in.hasNext()) {
                if (in.peek() == JsonToken.STRING) {
                    value.append("\"" + in.nextString() + "\"");
                } else {
                    this.readValueObject(value, in);
                }
                if (in.peek() == JsonToken.END_ARRAY) continue;
                value.append(",");
            }
            in.endArray();
            value.append("]");
        } else {
            this.readValueObject(value, in);
        }
        in.endObject();
        value.append("}");
    }

    private void readValueObject(@Nonnull StringBuffer value, @Nonnull JsonReader in) throws IOException {
        if (in.peek() == JsonToken.STRING) {
            value.append("\"" + in.nextString() + "\"");
            return;
        }
        in.beginObject();
        value.append("{");
        while (in.hasNext()) {
            value.append("\"" + in.nextName() + "\"");
            value.append(":");
            if (in.peek() == JsonToken.STRING) {
                value.append("\"" + in.nextString() + "\"");
            } else if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                value.append("[");
                while (in.hasNext()) {
                    if (in.peek() == JsonToken.STRING) {
                        value.append("\"" + in.nextString() + "\"");
                    } else {
                        this.readValueObject(value, in);
                    }
                    if (in.peek() == JsonToken.END_ARRAY) continue;
                    value.append(",");
                }
                in.endArray();
                value.append("]");
            } else {
                this.readValueObject(value, in);
            }
            if (in.peek() == JsonToken.END_OBJECT) continue;
            value.append(",");
        }
        in.endObject();
        value.append("}");
    }

    private static NormalizedNode<?, ?> readEditData(@Nonnull JsonReader in, @Nonnull SchemaNode targetSchemaNode, @Nonnull InstanceIdentifierContext<?> path) {
        NormalizedNodeResult resultHolder = new NormalizedNodeResult();
        NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
        JsonParserStream.create((NormalizedNodeStreamWriter)writer, (JSONCodecFactory)JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.getShared(path.getSchemaContext()), (SchemaNode)targetSchemaNode).parse(in);
        return resultHolder.getResult();
    }

    private static PatchEntity prepareEditOperation(@Nonnull PatchEdit edit) {
        if (edit.getOperation() != null && edit.getTargetSchemaNode() != null && JsonToPatchBodyReader.checkDataPresence(edit.getOperation(), edit.getData() != null)) {
            if (edit.getOperation().isWithValue()) {
                YangInstanceIdentifier targetNode = edit.getTarget().getLastPathArgument() instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates ? edit.getTarget().getParent() : edit.getTarget();
                return new PatchEntity(edit.getId(), edit.getOperation(), targetNode, edit.getData());
            }
            return new PatchEntity(edit.getId(), edit.getOperation(), edit.getTarget());
        }
        throw new RestconfDocumentedException("Error parsing input", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
    }

    private static boolean checkDataPresence(@Nonnull PatchEditOperation operation, boolean hasData) {
        return operation.isWithValue() == hasData;
    }

    private static final class PatchEdit {
        private String id;
        private PatchEditOperation operation;
        private YangInstanceIdentifier target;
        private SchemaNode targetSchemaNode;
        private NormalizedNode<?, ?> data;

        private PatchEdit() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public PatchEditOperation getOperation() {
            return this.operation;
        }

        public void setOperation(PatchEditOperation operation) {
            this.operation = operation;
        }

        public YangInstanceIdentifier getTarget() {
            return this.target;
        }

        public void setTarget(YangInstanceIdentifier target) {
            this.target = target;
        }

        public SchemaNode getTargetSchemaNode() {
            return this.targetSchemaNode;
        }

        public void setTargetSchemaNode(SchemaNode targetSchemaNode) {
            this.targetSchemaNode = targetSchemaNode;
        }

        public NormalizedNode<?, ?> getData() {
            return this.data;
        }

        public void setData(NormalizedNode<?, ?> data) {
            this.data = data;
        }

        public void clear() {
            this.id = null;
            this.operation = null;
            this.target = null;
            this.targetSchemaNode = null;
            this.data = null;
        }
    }
}

