/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.rest.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.netconf.sal.rest.api.RestconfNormalizedNodeWriter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamAttributeWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DepthAwareNormalizedNodeWriter
implements RestconfNormalizedNodeWriter {
    private final NormalizedNodeStreamWriter writer;
    protected int currentDepth = 0;
    protected final int maxDepth;

    private DepthAwareNormalizedNodeWriter(NormalizedNodeStreamWriter writer, int maxDepth) {
        this.writer = (NormalizedNodeStreamWriter)Preconditions.checkNotNull((Object)writer);
        this.maxDepth = maxDepth;
    }

    protected final NormalizedNodeStreamWriter getWriter() {
        return this.writer;
    }

    public static DepthAwareNormalizedNodeWriter forStreamWriter(NormalizedNodeStreamWriter writer, int maxDepth) {
        return DepthAwareNormalizedNodeWriter.forStreamWriter(writer, true, maxDepth);
    }

    public static DepthAwareNormalizedNodeWriter forStreamWriter(NormalizedNodeStreamWriter writer, boolean orderKeyLeaves, int maxDepth) {
        return orderKeyLeaves ? new OrderedDepthAwareNormalizedNodeWriter(writer, maxDepth) : new DepthAwareNormalizedNodeWriter(writer, maxDepth);
    }

    @Override
    public final DepthAwareNormalizedNodeWriter write(NormalizedNode<?, ?> node) throws IOException {
        if (this.wasProcessedAsCompositeNode(node)) {
            return this;
        }
        if (this.wasProcessAsSimpleNode(node)) {
            return this;
        }
        throw new IllegalStateException("It wasn't possible to serialize node " + node);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    static final int childSizeHint(Iterable<?> children) {
        return children instanceof Collection ? ((Collection)children).size() : -1;
    }

    private boolean wasProcessAsSimpleNode(NormalizedNode<?, ?> node) throws IOException {
        if (node instanceof LeafSetEntryNode) {
            if (this.currentDepth < this.maxDepth) {
                LeafSetEntryNode nodeAsLeafList = (LeafSetEntryNode)node;
                if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
                    ((NormalizedNodeStreamAttributeWriter)this.writer).leafSetEntryNode(nodeAsLeafList.getNodeType(), nodeAsLeafList.getValue(), nodeAsLeafList.getAttributes());
                } else {
                    this.writer.leafSetEntryNode(nodeAsLeafList.getNodeType(), nodeAsLeafList.getValue());
                }
            }
            return true;
        }
        if (node instanceof LeafNode) {
            LeafNode nodeAsLeaf = (LeafNode)node;
            if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
                ((NormalizedNodeStreamAttributeWriter)this.writer).leafNode((YangInstanceIdentifier.NodeIdentifier)nodeAsLeaf.getIdentifier(), nodeAsLeaf.getValue(), nodeAsLeaf.getAttributes());
            } else {
                this.writer.leafNode((YangInstanceIdentifier.NodeIdentifier)nodeAsLeaf.getIdentifier(), nodeAsLeaf.getValue());
            }
            return true;
        }
        if (node instanceof AnyXmlNode) {
            AnyXmlNode anyXmlNode = (AnyXmlNode)node;
            this.writer.anyxmlNode((YangInstanceIdentifier.NodeIdentifier)anyXmlNode.getIdentifier(), (Object)anyXmlNode.getValue());
            return true;
        }
        return false;
    }

    protected final boolean writeChildren(Iterable<? extends NormalizedNode<?, ?>> children) throws IOException {
        if (this.currentDepth < this.maxDepth) {
            for (NormalizedNode<?, ?> child : children) {
                this.write((NormalizedNode)child);
            }
        }
        this.writer.endNode();
        return true;
    }

    protected boolean writeMapEntryChildren(MapEntryNode mapEntryNode) throws IOException {
        if (this.currentDepth < this.maxDepth) {
            this.writeChildren(mapEntryNode.getValue());
        } else if (this.currentDepth == this.maxDepth) {
            this.writeOnlyKeys(mapEntryNode.getIdentifier().getKeyValues());
        }
        return true;
    }

    private void writeOnlyKeys(Map<QName, Object> keyValues) throws IllegalArgumentException, IOException {
        for (Map.Entry<QName, Object> entry : keyValues.entrySet()) {
            this.writer.leafNode(new YangInstanceIdentifier.NodeIdentifier(entry.getKey()), entry.getValue());
        }
        this.writer.endNode();
    }

    protected boolean writeMapEntryNode(MapEntryNode node) throws IOException {
        if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
            ((NormalizedNodeStreamAttributeWriter)this.writer).startMapEntryNode(node.getIdentifier(), DepthAwareNormalizedNodeWriter.childSizeHint(node.getValue()), node.getAttributes());
        } else {
            this.writer.startMapEntryNode(node.getIdentifier(), DepthAwareNormalizedNodeWriter.childSizeHint(node.getValue()));
        }
        ++this.currentDepth;
        this.writeMapEntryChildren(node);
        --this.currentDepth;
        return true;
    }

    private boolean wasProcessedAsCompositeNode(NormalizedNode<?, ?> node) throws IOException {
        boolean processedAsCompositeNode = false;
        if (node instanceof ContainerNode) {
            ContainerNode n = (ContainerNode)node;
            if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
                ((NormalizedNodeStreamAttributeWriter)this.writer).startContainerNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), DepthAwareNormalizedNodeWriter.childSizeHint(n.getValue()), n.getAttributes());
            } else {
                this.writer.startContainerNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), DepthAwareNormalizedNodeWriter.childSizeHint(n.getValue()));
            }
            ++this.currentDepth;
            processedAsCompositeNode = this.writeChildren(n.getValue());
            --this.currentDepth;
        } else if (node instanceof MapEntryNode) {
            processedAsCompositeNode = this.writeMapEntryNode((MapEntryNode)node);
        } else if (node instanceof UnkeyedListEntryNode) {
            UnkeyedListEntryNode n = (UnkeyedListEntryNode)node;
            this.writer.startUnkeyedListItem((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), DepthAwareNormalizedNodeWriter.childSizeHint(n.getValue()));
            ++this.currentDepth;
            processedAsCompositeNode = this.writeChildren(n.getValue());
            --this.currentDepth;
        } else if (node instanceof ChoiceNode) {
            ChoiceNode n = (ChoiceNode)node;
            this.writer.startChoiceNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), DepthAwareNormalizedNodeWriter.childSizeHint(n.getValue()));
            processedAsCompositeNode = this.writeChildren(n.getValue());
        } else if (node instanceof AugmentationNode) {
            AugmentationNode n = (AugmentationNode)node;
            this.writer.startAugmentationNode(n.getIdentifier());
            processedAsCompositeNode = this.writeChildren(n.getValue());
        } else if (node instanceof UnkeyedListNode) {
            UnkeyedListNode n = (UnkeyedListNode)node;
            this.writer.startUnkeyedList((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), DepthAwareNormalizedNodeWriter.childSizeHint((Iterable)n.getValue()));
            processedAsCompositeNode = this.writeChildren((Iterable)n.getValue());
        } else if (node instanceof OrderedMapNode) {
            OrderedMapNode n = (OrderedMapNode)node;
            this.writer.startOrderedMapNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), DepthAwareNormalizedNodeWriter.childSizeHint(n.getValue()));
            processedAsCompositeNode = this.writeChildren(n.getValue());
        } else if (node instanceof MapNode) {
            MapNode n = (MapNode)node;
            this.writer.startMapNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), DepthAwareNormalizedNodeWriter.childSizeHint(n.getValue()));
            processedAsCompositeNode = this.writeChildren(n.getValue());
        } else if (node instanceof LeafSetNode) {
            LeafSetNode n = (LeafSetNode)node;
            if (node instanceof OrderedLeafSetNode) {
                this.writer.startOrderedLeafSet((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), DepthAwareNormalizedNodeWriter.childSizeHint(n.getValue()));
            } else {
                this.writer.startLeafSet((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), DepthAwareNormalizedNodeWriter.childSizeHint(n.getValue()));
            }
            ++this.currentDepth;
            processedAsCompositeNode = this.writeChildren(n.getValue());
            --this.currentDepth;
        }
        return processedAsCompositeNode;
    }

    private static final class OrderedDepthAwareNormalizedNodeWriter
    extends DepthAwareNormalizedNodeWriter {
        private static final Logger LOG = LoggerFactory.getLogger(OrderedDepthAwareNormalizedNodeWriter.class);

        OrderedDepthAwareNormalizedNodeWriter(NormalizedNodeStreamWriter writer, int maxDepth) {
            super(writer, maxDepth);
        }

        @Override
        protected boolean writeMapEntryNode(MapEntryNode node) throws IOException {
            NormalizedNodeStreamWriter writer = this.getWriter();
            if (writer instanceof NormalizedNodeStreamAttributeWriter) {
                ((NormalizedNodeStreamAttributeWriter)writer).startMapEntryNode(node.getIdentifier(), OrderedDepthAwareNormalizedNodeWriter.childSizeHint(node.getValue()), node.getAttributes());
            } else {
                writer.startMapEntryNode(node.getIdentifier(), OrderedDepthAwareNormalizedNodeWriter.childSizeHint(node.getValue()));
            }
            Set qnames = node.getIdentifier().getKeyValues().keySet();
            for (QName qname : qnames) {
                Optional child = node.getChild((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(qname));
                if (child.isPresent()) {
                    this.write((NormalizedNode)child.get());
                    continue;
                }
                LOG.info("No child for key element {} found", (Object)qname);
            }
            ++this.currentDepth;
            boolean result = this.writeChildren(Iterables.filter((Iterable)node.getValue(), input -> {
                if (input instanceof AugmentationNode) {
                    return true;
                }
                if (!qnames.contains(input.getNodeType())) {
                    return true;
                }
                LOG.debug("Skipping key child {}", input);
                return false;
            }));
            --this.currentDepth;
            return result;
        }
    }
}

