/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.md.sal.rest.schema;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.time.format.DateTimeParseException;
import java.util.Iterator;
import org.opendaylight.mdsal.dom.api.DOMYangTextSourceProvider;
import org.opendaylight.netconf.md.sal.rest.schema.SchemaRetrievalService;
import org.opendaylight.netconf.sal.restconf.impl.ControllerContext;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.schema.SchemaExportContext;
import org.opendaylight.restconf.common.validation.RestconfValidationUtils;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class SchemaRetrievalServiceImpl
implements SchemaRetrievalService {
    private final ControllerContext salContext;
    private static final Splitter SLASH_SPLITTER = Splitter.on((String)"/");
    private static final String MOUNT_ARG = "yang-ext:mount";

    public SchemaRetrievalServiceImpl(ControllerContext controllerContext) {
        this.salContext = controllerContext;
    }

    @Override
    public SchemaExportContext getSchema(String mountAndModule) {
        SchemaContext schemaContext;
        Iterable pathComponents = SLASH_SPLITTER.split((CharSequence)mountAndModule);
        Iterator componentIter = pathComponents.iterator();
        if (!Iterables.contains((Iterable)pathComponents, (Object)MOUNT_ARG)) {
            schemaContext = this.salContext.getGlobalSchema();
        } else {
            StringBuilder pathBuilder = new StringBuilder();
            while (componentIter.hasNext()) {
                String current = (String)componentIter.next();
                if (pathBuilder.length() != 0) {
                    pathBuilder.append("/");
                }
                pathBuilder.append(current);
                if (!MOUNT_ARG.equals(current)) continue;
                break;
            }
            schemaContext = this.getMountSchemaContext(pathBuilder.toString());
        }
        RestconfValidationUtils.checkDocumentedError((boolean)componentIter.hasNext(), (RestconfError.ErrorType)RestconfError.ErrorType.PROTOCOL, (RestconfError.ErrorTag)RestconfError.ErrorTag.INVALID_VALUE, (String)"Module name must be supplied.");
        String moduleName = (String)componentIter.next();
        RestconfValidationUtils.checkDocumentedError((boolean)componentIter.hasNext(), (RestconfError.ErrorType)RestconfError.ErrorType.PROTOCOL, (RestconfError.ErrorTag)RestconfError.ErrorTag.INVALID_VALUE, (String)"Revision date must be supplied.");
        String revisionString = (String)componentIter.next();
        return SchemaRetrievalServiceImpl.getExportUsingNameAndRevision(schemaContext, moduleName, revisionString, this.salContext.getYangTextSourceProvider());
    }

    private static SchemaExportContext getExportUsingNameAndRevision(SchemaContext schemaContext, String moduleName, String revisionStr, DOMYangTextSourceProvider yangTextSourceProvider) {
        try {
            Module module = schemaContext.findModule(moduleName, Revision.of((String)revisionStr)).orElse(null);
            return new SchemaExportContext(schemaContext, (Module)RestconfValidationUtils.checkNotNullDocumented((Object)module, (String)moduleName), yangTextSourceProvider);
        }
        catch (DateTimeParseException e) {
            throw new RestconfDocumentedException("Supplied revision is not in expected date format YYYY-mm-dd", (Throwable)e);
        }
    }

    private SchemaContext getMountSchemaContext(String identifier) {
        InstanceIdentifierContext<?> mountContext = this.salContext.toMountPointIdentifier(identifier);
        return mountContext.getSchemaContext();
    }
}

