/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class TopicId
implements TypeObject,
Serializable {
    private static final long serialVersionUID = 4967737107608561345L;
    private final String _value;

    private static void check_valueLength(String value) {
        int length = value.length();
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..2147483647]]", (Object)value);
    }

    @ConstructorProperties(value={"value"})
    public TopicId(String _value) {
        if (_value != null) {
            TopicId.check_valueLength(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public TopicId(TopicId source) {
        this._value = source._value;
    }

    public static TopicId getDefaultInstance(String defaultValue) {
        return new TopicId(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicId other = (TopicId)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(TopicId.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
        return helper.toString();
    }
}

