/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.web.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.apache.aries.blueprint.annotation.service.Reference;
import org.opendaylight.aaa.web.ResourceDetails;
import org.opendaylight.aaa.web.ServletDetails;
import org.opendaylight.aaa.web.WebContext;
import org.opendaylight.aaa.web.WebContextRegistration;
import org.opendaylight.aaa.web.WebServer;
import org.opendaylight.aaa.web.osgi.MapDictionary;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.WebContainerDTO;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PaxWebServer {
    private static final Logger LOG = LoggerFactory.getLogger(PaxWebServer.class);
    private final WebContainer paxWeb;
    private final ServiceRegistration<?> serviceRegistration;

    @Inject
    public PaxWebServer(@Reference WebContainer paxWebContainer, BundleContext bundleContext) {
        this.paxWeb = paxWebContainer;
        this.serviceRegistration = bundleContext.registerService(new String[]{WebServer.class.getName()}, (Object)new ServiceFactory<WebServer>(){

            public WebServer getService(Bundle bundle, ServiceRegistration<WebServer> registration) {
                return PaxWebServer.this.newWebServer(bundle);
            }

            public void ungetService(Bundle bundle, ServiceRegistration<WebServer> registration, WebServer service) {
            }
        }, new MapDictionary(Collections.emptyMap()));
        LOG.info("PaxWebServer initialized & WebServer service factory registered");
    }

    @PreDestroy
    public void close() {
        this.serviceRegistration.unregister();
    }

    private String getBaseURL() {
        WebContainerDTO details = this.paxWeb.getWebcontainerDTO();
        if (details.securePort != null && details.securePort > 0) {
            return "https://" + details.listeningAddresses[0] + ":" + details.securePort;
        }
        return "http://" + details.listeningAddresses[0] + ":" + details.port;
    }

    private WebServer newWebServer(Bundle bundle) throws IllegalStateException {
        LOG.info("Creating WebServer instance for bundle {}", (Object)bundle);
        final BundleContext bundleContext = bundle.getBundleContext();
        final ServiceReference webContainerServiceRef = bundleContext.getServiceReference(WebContainer.class);
        final WebContainer bundleWebContainer = webContainerServiceRef != null ? (WebContainer)bundleContext.getService(webContainerServiceRef) : null;
        if (bundleWebContainer == null) {
            throw new IllegalStateException("WebContainer OSGi service not found using bundle: " + bundle.toString());
        }
        return new WebServer(){

            public WebContextRegistration registerWebContext(WebContext webContext) throws ServletException {
                return new WebContextImpl(bundleWebContainer, webContext){

                    @Override
                    public void close() {
                        super.close();
                        try {
                            bundleContext.ungetService(webContainerServiceRef);
                        }
                        catch (IllegalStateException e) {
                            LOG.debug("Error from ungetService", (Throwable)e);
                        }
                    }
                };
            }

            public String getBaseURL() {
                return PaxWebServer.this.getBaseURL();
            }
        };
    }

    private static class WebContextImpl
    implements WebContextRegistration {
        private final String contextPath;
        private final WebContainer paxWeb;
        private final List<Servlet> registeredServlets = new ArrayList<Servlet>();
        private final List<EventListener> registeredEventListeners = new ArrayList<EventListener>();
        private final List<Filter> registeredFilters = new ArrayList<Filter>();
        private final List<String> registeredResources = new ArrayList<String>();

        WebContextImpl(WebContainer paxWeb, WebContext webContext) throws ServletException {
            this.paxWeb = paxWeb;
            this.contextPath = webContext.contextPath();
            String contextID = this.contextPath + ".id";
            HttpContext osgiHttpContext = paxWeb.createDefaultHttpContext(contextID);
            paxWeb.begin(osgiHttpContext);
            paxWeb.setContextParam(new MapDictionary(webContext.contextParams()), osgiHttpContext);
            webContext.listeners().forEach(listener -> this.registerListener(osgiHttpContext, (ServletContextListener)listener));
            webContext.filters().forEach(filter -> this.registerFilter(osgiHttpContext, filter.urlPatterns(), filter.name(), filter.filter(), filter.initParams()));
            for (ServletDetails servlet : webContext.servlets()) {
                this.registerServlet(osgiHttpContext, servlet.urlPatterns(), servlet.name(), servlet.servlet(), servlet.initParams());
            }
            try {
                for (ResourceDetails resource : webContext.resources()) {
                    String alias = WebContextImpl.ensurePrependedSlash(this.contextPath + WebContextImpl.ensurePrependedSlash(resource.alias()));
                    paxWeb.registerResources(alias, WebContextImpl.ensurePrependedSlash(resource.name()), osgiHttpContext);
                    this.registeredResources.add(alias);
                }
            }
            catch (NamespaceException e) {
                throw new ServletException("Error registering resources", (Throwable)e);
            }
            paxWeb.end(osgiHttpContext);
        }

        private static String ensurePrependedSlash(String str) {
            return !str.startsWith("/") ? "/" + str : str;
        }

        void registerFilter(HttpContext osgiHttpContext, List<String> urlPatterns, String name, Filter filter, Map<String, String> params) {
            boolean asyncSupported = false;
            String[] absUrlPatterns = this.absolute(urlPatterns);
            LOG.info("Registering Filter for aliases {}: {}", (Object)absUrlPatterns, (Object)filter);
            this.paxWeb.registerFilter(filter, absUrlPatterns, new String[]{name}, new MapDictionary<String, String>(params), Boolean.valueOf(asyncSupported), osgiHttpContext);
            this.registeredFilters.add(filter);
        }

        String[] absolute(List<String> relatives) {
            return (String[])relatives.stream().map(urlPattern -> this.contextPath + urlPattern).toArray(String[]::new);
        }

        void registerServlet(HttpContext osgiHttpContext, List<String> urlPatterns, String name, Servlet servlet, Map<String, String> params) throws ServletException {
            int loadOnStartup = 1;
            boolean asyncSupported = false;
            String[] absUrlPatterns = this.absolute(urlPatterns);
            LOG.info("Registering Servlet for aliases {}: {}", (Object)absUrlPatterns, (Object)servlet);
            this.paxWeb.registerServlet(servlet, name, absUrlPatterns, new MapDictionary<String, String>(params), Integer.valueOf(loadOnStartup), Boolean.valueOf(asyncSupported), osgiHttpContext);
            this.registeredServlets.add(servlet);
        }

        void registerListener(HttpContext osgiHttpContext, ServletContextListener listener) {
            this.paxWeb.registerEventListener((EventListener)listener, osgiHttpContext);
            this.registeredEventListeners.add((EventListener)listener);
        }

        public void close() {
            for (Servlet registeredServlet : this.registeredServlets) {
                this.paxWeb.unregisterServlet(registeredServlet);
            }
            for (Filter filter : this.registeredFilters) {
                this.paxWeb.unregisterFilter(filter);
            }
            for (EventListener eventListener : this.registeredEventListeners) {
                this.paxWeb.unregisterEventListener(eventListener);
            }
            for (String alias : this.registeredResources) {
                this.paxWeb.unregister(alias);
            }
        }
    }
}

