/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.web.osgi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class MapDictionary<K, V>
extends Dictionary<K, V> {
    private final Map<K, V> map;

    MapDictionary(Map<K, V> map) {
        this.map = ImmutableMap.copyOf(map);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Enumeration<K> keys() {
        return Iterators.asEnumeration(this.map.keySet().iterator());
    }

    @Override
    public Enumeration<V> elements() {
        return Iterators.asEnumeration(this.map.values().iterator());
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }
}

