/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.network;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.NetworkId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.network.SupportingNetwork;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.network.SupportingNetworkKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SupportingNetworkBuilder
implements Builder<SupportingNetwork> {
    private NetworkId _networkRef;
    private SupportingNetworkKey key;
    Map<Class<? extends Augmentation<SupportingNetwork>>, Augmentation<SupportingNetwork>> augmentation = Collections.emptyMap();

    public SupportingNetworkBuilder() {
    }

    public SupportingNetworkBuilder(SupportingNetwork base) {
        Map aug;
        this.key = base.key();
        this._networkRef = base.getNetworkRef();
        if (base instanceof SupportingNetworkImpl) {
            SupportingNetworkImpl impl = (SupportingNetworkImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SupportingNetwork>>, Augmentation<SupportingNetwork>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportingNetwork>>, Augmentation<SupportingNetwork>>(aug);
        }
    }

    public SupportingNetworkKey key() {
        return this.key;
    }

    public NetworkId getNetworkRef() {
        return this._networkRef;
    }

    public <E extends Augmentation<SupportingNetwork>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public SupportingNetworkBuilder withKey(SupportingNetworkKey key) {
        this.key = key;
        return this;
    }

    public SupportingNetworkBuilder setNetworkRef(NetworkId value) {
        this._networkRef = value;
        return this;
    }

    public SupportingNetworkBuilder addAugmentation(Class<? extends Augmentation<SupportingNetwork>> augmentationType, Augmentation<SupportingNetwork> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportingNetwork>>, Augmentation<SupportingNetwork>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SupportingNetworkBuilder removeAugmentation(Class<? extends Augmentation<SupportingNetwork>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SupportingNetwork build() {
        return new SupportingNetworkImpl(this);
    }

    private static final class SupportingNetworkImpl
    implements SupportingNetwork {
        private final NetworkId _networkRef;
        private final SupportingNetworkKey key;
        private Map<Class<? extends Augmentation<SupportingNetwork>>, Augmentation<SupportingNetwork>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        SupportingNetworkImpl(SupportingNetworkBuilder base) {
            this.key = base.key() != null ? base.key() : new SupportingNetworkKey(base.getNetworkRef());
            this._networkRef = this.key.getNetworkRef();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<SupportingNetwork> getImplementedInterface() {
            return SupportingNetwork.class;
        }

        @Override
        public SupportingNetworkKey key() {
            return this.key;
        }

        @Override
        public NetworkId getNetworkRef() {
            return this._networkRef;
        }

        public <E extends Augmentation<SupportingNetwork>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._networkRef);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SupportingNetwork.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SupportingNetwork other = (SupportingNetwork)obj;
            if (!Objects.equals(this._networkRef, other.getNetworkRef())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SupportingNetworkImpl otherImpl = (SupportingNetworkImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SupportingNetwork>>, Augmentation<SupportingNetwork>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"SupportingNetwork");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_networkRef", (Object)this._networkRef);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

