/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.NetworkId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.Network;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.NetworkKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.network.NetworkTypes;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.network.Node;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.network.SupportingNetwork;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NetworkBuilder
implements Builder<Network> {
    private NetworkId _networkId;
    private NetworkTypes _networkTypes;
    private List<Node> _node;
    private List<SupportingNetwork> _supportingNetwork;
    private NetworkKey key;
    Map<Class<? extends Augmentation<Network>>, Augmentation<Network>> augmentation = Collections.emptyMap();

    public NetworkBuilder() {
    }

    public NetworkBuilder(Network base) {
        Map aug;
        this.key = base.key();
        this._networkId = base.getNetworkId();
        this._networkTypes = base.getNetworkTypes();
        this._node = base.getNode();
        this._supportingNetwork = base.getSupportingNetwork();
        if (base instanceof NetworkImpl) {
            NetworkImpl impl = (NetworkImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Network>>, Augmentation<Network>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Network>>, Augmentation<Network>>(aug);
        }
    }

    public NetworkKey key() {
        return this.key;
    }

    public NetworkId getNetworkId() {
        return this._networkId;
    }

    public NetworkTypes getNetworkTypes() {
        return this._networkTypes;
    }

    public List<Node> getNode() {
        return this._node;
    }

    public List<SupportingNetwork> getSupportingNetwork() {
        return this._supportingNetwork;
    }

    public <E extends Augmentation<Network>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NetworkBuilder withKey(NetworkKey key) {
        this.key = key;
        return this;
    }

    public NetworkBuilder setNetworkId(NetworkId value) {
        this._networkId = value;
        return this;
    }

    public NetworkBuilder setNetworkTypes(NetworkTypes value) {
        this._networkTypes = value;
        return this;
    }

    public NetworkBuilder setNode(List<Node> values) {
        this._node = values;
        return this;
    }

    public NetworkBuilder setSupportingNetwork(List<SupportingNetwork> values) {
        this._supportingNetwork = values;
        return this;
    }

    public NetworkBuilder addAugmentation(Class<? extends Augmentation<Network>> augmentationType, Augmentation<Network> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Network>>, Augmentation<Network>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NetworkBuilder removeAugmentation(Class<? extends Augmentation<Network>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Network build() {
        return new NetworkImpl(this);
    }

    private static final class NetworkImpl
    implements Network {
        private final NetworkId _networkId;
        private final NetworkTypes _networkTypes;
        private final List<Node> _node;
        private final List<SupportingNetwork> _supportingNetwork;
        private final NetworkKey key;
        private Map<Class<? extends Augmentation<Network>>, Augmentation<Network>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NetworkImpl(NetworkBuilder base) {
            this.key = base.key() != null ? base.key() : new NetworkKey(base.getNetworkId());
            this._networkId = this.key.getNetworkId();
            this._networkTypes = base.getNetworkTypes();
            this._node = base.getNode();
            this._supportingNetwork = base.getSupportingNetwork();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Network> getImplementedInterface() {
            return Network.class;
        }

        @Override
        public NetworkKey key() {
            return this.key;
        }

        @Override
        public NetworkId getNetworkId() {
            return this._networkId;
        }

        @Override
        public NetworkTypes getNetworkTypes() {
            return this._networkTypes;
        }

        @Override
        public List<Node> getNode() {
            return this._node;
        }

        @Override
        public List<SupportingNetwork> getSupportingNetwork() {
            return this._supportingNetwork;
        }

        public <E extends Augmentation<Network>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._networkId);
            result = 31 * result + Objects.hashCode(this._networkTypes);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._supportingNetwork);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Network.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Network other = (Network)obj;
            if (!Objects.equals(this._networkId, other.getNetworkId())) {
                return false;
            }
            if (!Objects.equals(this._networkTypes, other.getNetworkTypes())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._supportingNetwork, other.getSupportingNetwork())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NetworkImpl otherImpl = (NetworkImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Network>>, Augmentation<Network>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Network");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_networkId", (Object)this._networkId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_networkTypes", (Object)this._networkTypes);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_node", this._node);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_supportingNetwork", this._supportingNetwork);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

