/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.Networks;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.Network;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NetworksBuilder
implements Builder<Networks> {
    private List<Network> _network;
    Map<Class<? extends Augmentation<Networks>>, Augmentation<Networks>> augmentation = Collections.emptyMap();

    public NetworksBuilder() {
    }

    public NetworksBuilder(Networks base) {
        Map aug;
        this._network = base.getNetwork();
        if (base instanceof NetworksImpl) {
            NetworksImpl impl = (NetworksImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Networks>>, Augmentation<Networks>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Networks>>, Augmentation<Networks>>(aug);
        }
    }

    public List<Network> getNetwork() {
        return this._network;
    }

    public <E extends Augmentation<Networks>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NetworksBuilder setNetwork(List<Network> values) {
        this._network = values;
        return this;
    }

    public NetworksBuilder addAugmentation(Class<? extends Augmentation<Networks>> augmentationType, Augmentation<Networks> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Networks>>, Augmentation<Networks>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NetworksBuilder removeAugmentation(Class<? extends Augmentation<Networks>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Networks build() {
        return new NetworksImpl(this);
    }

    private static final class NetworksImpl
    implements Networks {
        private final List<Network> _network;
        private Map<Class<? extends Augmentation<Networks>>, Augmentation<Networks>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NetworksImpl(NetworksBuilder base) {
            this._network = base.getNetwork();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Networks> getImplementedInterface() {
            return Networks.class;
        }

        @Override
        public List<Network> getNetwork() {
            return this._network;
        }

        public <E extends Augmentation<Networks>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._network);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Networks.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Networks other = (Networks)obj;
            if (!Objects.equals(this._network, other.getNetwork())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NetworksImpl otherImpl = (NetworksImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Networks>>, Augmentation<Networks>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Networks");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_network", this._network);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

