/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.http;

import com.google.common.base.Splitter;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.http.HttpServerHandler;
import org.opendaylight.jsonrpc.bus.http.PeerContextImpl;
import org.opendaylight.jsonrpc.bus.http.WebSocketServerHandler;
import org.opendaylight.jsonrpc.bus.spi.AbstractServerChannelInitializer;
import org.opendaylight.jsonrpc.bus.spi.ChannelGroupHandler;
import org.opendaylight.jsonrpc.bus.spi.CommonConstants;

class ServerInitializer
extends AbstractServerChannelInitializer {
    private final boolean useSsl;
    private final Boolean isWebSocket;
    private final SslContext sslContext;
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');

    ServerInitializer(SessionType socketType, EventExecutorGroup handlerExecutor, ChannelGroup channelGroup, MessageListener messageListener, boolean useSsl, Map<String, String> opts, boolean isWebSocket) {
        super(socketType, handlerExecutor, channelGroup, messageListener);
        this.useSsl = useSsl;
        this.isWebSocket = isWebSocket;
        this.sslContext = useSsl ? this.setupSsl(opts) : null;
    }

    private SslContext setupSsl(Map<String, String> opts) {
        try {
            File certFile = new File(opts.get("certfile"));
            String password = opts.get("privatekeypassword");
            Iterable ciphers = opts.containsKey("ciphers") ? COMMA_SPLITTER.split((CharSequence)opts.get("ciphers")) : null;
            KeyStore ks = KeyStore.getInstance(opts.computeIfAbsent("keystore", k -> "PKCS12"));
            try (InputStream is = Files.newInputStream(certFile.toPath(), new OpenOption[0]);){
                ks.load(is, password.toCharArray());
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(opts.computeIfAbsent("kmf", v -> "SunX509"));
            kmf.init(ks, password.toCharArray());
            return SslContextBuilder.forServer((KeyManagerFactory)kmf).ciphers(ciphers).build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException("Failed to initialize SSL", e);
        }
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        super.initChannel(ch);
        ch.attr(CommonConstants.ATTR_PEER_CONTEXT).set((Object)new PeerContextImpl((Channel)ch, this.isWebSocket, this.useSsl));
        if (this.useSsl) {
            ch.pipeline().addLast("ssl", (ChannelHandler)this.sslContext.newHandler(ch.alloc()));
        }
        ServerInitializer.configureLogging((Channel)ch);
        ch.pipeline().addLast("conn-tracker", (ChannelHandler)new ChannelGroupHandler(this.channelGroup));
        ch.pipeline().addLast("codec", (ChannelHandler)new HttpServerCodec());
        ch.pipeline().addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(262144));
        if (this.isWebSocket.booleanValue()) {
            ch.pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/")});
            ch.pipeline().addLast(this.handlerExecutor, "listener-adapter", (ChannelHandler)new WebSocketServerHandler(this.messageListener));
        } else {
            ch.pipeline().addLast(this.handlerExecutor, "listener-adapter", (ChannelHandler)new HttpServerHandler(this.messageListener));
        }
    }
}

