/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.http;

import io.netty.bootstrap.Bootstrap;
import io.netty.util.concurrent.DefaultProgressivePromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.jsonrpc.bus.api.RecoverableTransportException;
import org.opendaylight.jsonrpc.bus.api.Requester;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.http.AbstractClientSession;
import org.opendaylight.jsonrpc.bus.http.HttpUtil;
import org.opendaylight.jsonrpc.bus.spi.AbstractChannelInitializer;
import org.opendaylight.jsonrpc.bus.spi.CommonConstants;

class RequesterImpl
extends AbstractClientSession
implements Requester {
    RequesterImpl(String uri, int defaultPort, Bootstrap clientBootstrap, AbstractChannelInitializer channelInitializer, boolean isWebsocket) {
        super(uri, defaultPort, clientBootstrap, channelInitializer, isWebsocket, SessionType.REQ);
        this.connectInternal();
    }

    public Future<String> send(String message) {
        if (!this.isReady()) {
            throw new RecoverableTransportException(this.sessionType, this.uri.toString());
        }
        DefaultProgressivePromise promise = new DefaultProgressivePromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        ((AtomicReference)this.channelFuture.channel().attr(CommonConstants.ATTR_RESPONSE_QUEUE).get()).set(promise);
        this.channelFuture.channel().writeAndFlush(HttpUtil.createRequestObject(this.isWebsocket, message));
        return promise;
    }
}

