/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.SocketChannel;
import java.net.SocketAddress;
import org.opendaylight.jsonrpc.bus.api.Publisher;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.http.HttpUtil;
import org.opendaylight.jsonrpc.bus.spi.AbstractServerSession;

class PublisherImpl
extends AbstractServerSession
implements Publisher {
    PublisherImpl(String uri, int defaultPort, ServerBootstrap serverBootstrap, ChannelInitializer<SocketChannel> channelInitializer, ChannelGroup channelGroup, boolean useSsl) {
        super(uri, defaultPort, channelGroup, SessionType.PUB);
        this.channelFuture = serverBootstrap.childHandler(channelInitializer).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).bind((SocketAddress)this.address).syncUninterruptibly();
    }

    public void publish(String message, String topic) {
        this.channelGroup.writeAndFlush(HttpUtil.createRequestObject(true, message));
    }
}

