/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.http;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.jsonrpc.bus.api.BusSession;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.Publisher;
import org.opendaylight.jsonrpc.bus.api.Requester;
import org.opendaylight.jsonrpc.bus.api.Responder;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.api.Subscriber;
import org.opendaylight.jsonrpc.bus.http.ClientInitializer;
import org.opendaylight.jsonrpc.bus.http.PublisherImpl;
import org.opendaylight.jsonrpc.bus.http.RequesterImpl;
import org.opendaylight.jsonrpc.bus.http.ResponderImpl;
import org.opendaylight.jsonrpc.bus.http.ServerInitializer;
import org.opendaylight.jsonrpc.bus.http.SubscriberImpl;
import org.opendaylight.jsonrpc.bus.spi.AbstractBusSessionFactory;
import org.opendaylight.jsonrpc.bus.spi.AbstractChannelInitializer;
import org.opendaylight.jsonrpc.bus.spi.DiscardingMessageListener;
import org.opendaylight.jsonrpc.bus.spi.EventLoopConfiguration;

abstract class AbstractWebBusSessionFactory
extends AbstractBusSessionFactory {
    private static final Splitter.MapSplitter QUERY_SPLITER = Splitter.on((char)'&').withKeyValueSeparator('=');
    protected final boolean useSsl;
    protected final boolean isWebsocket;
    protected final int defaultPort;

    AbstractWebBusSessionFactory(String name, boolean useSsl, boolean isWebsocket, int defaultPort) {
        super(name);
        this.isWebsocket = isWebsocket;
        this.useSsl = useSsl;
        this.defaultPort = defaultPort;
    }

    AbstractWebBusSessionFactory(String name, boolean useSsl, boolean isWebsocket, int defaultPort, EventLoopConfiguration config) {
        super(name, config);
        this.isWebsocket = isWebsocket;
        this.useSsl = useSsl;
        this.defaultPort = defaultPort;
    }

    public Publisher publisher(String uri) {
        if (!this.isWebsocket) {
            this.throwUnsupported(SessionType.PUB);
        }
        DefaultChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        PublisherImpl session = new PublisherImpl(uri, this.defaultPort, this.serverBootstrap, this.createServerInitializer(SessionType.PUB, (MessageListener)DiscardingMessageListener.INSTANCE, (ChannelGroup)channelGroup, uri), (ChannelGroup)channelGroup, this.useSsl);
        this.addSession((BusSession)session);
        return session;
    }

    public Subscriber subscriber(String uri, String topic, MessageListener listener) {
        if (!this.isWebsocket) {
            this.throwUnsupported(SessionType.SUB);
        }
        SubscriberImpl session = new SubscriberImpl(uri, this.defaultPort, this.clientBootstrap, this.createClientInitializer(SessionType.SUB, this.handlerExecutor, uri, listener));
        this.addSession((BusSession)session);
        return session;
    }

    public Requester requester(String uri, MessageListener listener) {
        RequesterImpl session = new RequesterImpl(uri, this.defaultPort, this.clientBootstrap, this.createClientInitializer(SessionType.REQ, this.handlerExecutor, uri, listener), this.isWebsocket);
        this.addSession((BusSession)session);
        return session;
    }

    public Responder responder(String uri, MessageListener listener) {
        DefaultChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        ResponderImpl session = new ResponderImpl(uri, this.defaultPort, this.serverBootstrap, this.createServerInitializer(SessionType.REP, listener, (ChannelGroup)channelGroup, uri), (ChannelGroup)channelGroup);
        this.addSession((BusSession)session);
        return session;
    }

    private ChannelInitializer<SocketChannel> createServerInitializer(SessionType socketType, MessageListener listener, ChannelGroup channelGroup, String uri) {
        return new ServerInitializer(socketType, this.handlerExecutor, channelGroup, listener, this.useSsl, this.getOptions(uri), this.isWebsocket);
    }

    private Map<String, String> getOptions(String uriStr) {
        URI uri = AbstractWebBusSessionFactory.createUriUnchecked((String)uriStr);
        return Maps.newLinkedHashMap(!Strings.isNullOrEmpty((String)uri.getQuery()) ? QUERY_SPLITER.split((CharSequence)uri.getQuery()) : Collections.emptyMap());
    }

    private AbstractChannelInitializer createClientInitializer(SessionType socketType, EventExecutorGroup handlerExecutor, String uri, MessageListener listener) {
        return new ClientInitializer(socketType, handlerExecutor, this.useSsl, this.isWebsocket, AbstractWebBusSessionFactory.createUriUnchecked((String)uri), this.getOptions(uri), listener);
    }

    private void throwUnsupported(SessionType sessionType) {
        throw new UnsupportedOperationException(String.format("Transport '%s' does not support %s session type", this.name, sessionType.name()));
    }
}

