/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder.result;

import java.lang.reflect.Method;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.OptionalUtil;
import org.apache.deltaspike.core.util.StreamUtil;
import org.apache.deltaspike.data.api.Modifying;
import org.apache.deltaspike.data.api.QueryResult;
import org.apache.deltaspike.data.api.SingleResultType;
import org.apache.deltaspike.data.impl.builder.result.QueryProcessor;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.meta.RepositoryMethodMetadata;

@ApplicationScoped
public class QueryProcessorFactory {
    public QueryProcessor build(RepositoryMethodMetadata methodMetadata) {
        if (ClassUtils.returns((Method)methodMetadata.getMethod(), QueryResult.class)) {
            return new NoOpQueryProcessor();
        }
        if (ClassUtils.returns((Method)methodMetadata.getMethod(), List.class)) {
            return new ListQueryProcessor();
        }
        if (methodMetadata.isReturnsStream()) {
            return new StreamQueryProcessor();
        }
        if (this.isModifying(methodMetadata)) {
            return new ExecuteUpdateQueryProcessor(ClassUtils.returns((Method)methodMetadata.getMethod(), Void.TYPE));
        }
        return new SingleResultQueryProcessor();
    }

    private boolean isModifying(RepositoryMethodMetadata methodMetadata) {
        boolean matchesType = Void.TYPE.equals(methodMetadata.getMethod().getReturnType()) || Integer.TYPE.equals(methodMetadata.getMethod().getReturnType()) || Integer.class.equals(methodMetadata.getMethod().getReturnType());
        return methodMetadata.getMethod().isAnnotationPresent(Modifying.class) && matchesType || methodMetadata.getMethodPrefix().isDelete();
    }

    private static final class ExecuteUpdateQueryProcessor
    implements QueryProcessor {
        private final boolean returnsVoid;

        private ExecuteUpdateQueryProcessor(boolean returnsVoid) {
            this.returnsVoid = returnsVoid;
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            int result = query.executeUpdate();
            if (!this.returnsVoid) {
                return result;
            }
            return null;
        }
    }

    private static final class SingleResultQueryProcessor
    implements QueryProcessor {
        private SingleResultQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            SingleResultType style = context.getRepositoryMethodMetadata().getSingleResultType();
            Object result = null;
            switch (style) {
                case JPA: {
                    return query.getSingleResult();
                }
                case OPTIONAL: {
                    try {
                        result = query.getSingleResult();
                    }
                    catch (NoResultException noResultException) {}
                    break;
                }
                default: {
                    List queryResult = query.getResultList();
                    Object object = result = !queryResult.isEmpty() ? (Object)queryResult.get(0) : null;
                }
            }
            if (context.getRepositoryMethodMetadata().isReturnsOptional()) {
                return OptionalUtil.wrap((Object)result);
            }
            return result;
        }
    }

    private static final class StreamQueryProcessor
    implements QueryProcessor {
        private StreamQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            return StreamUtil.wrap((Object)query.getResultList());
        }
    }

    private static final class NoOpQueryProcessor
    implements QueryProcessor {
        private NoOpQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            return query;
        }
    }

    private static final class ListQueryProcessor
    implements QueryProcessor {
        private ListQueryProcessor() {
        }

        @Override
        public Object executeQuery(Query query, CdiQueryInvocationContext context) {
            return query.getResultList();
        }
    }
}

