/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev170126.restconf;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev170126.restconf.Restconf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev170126.restconf.restconf.Data;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.restconf.rev170126.restconf.restconf.Operations;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RestconfBuilder
implements Builder<Restconf> {
    private Data _data;
    private Operations _operations;
    private String _yangLibraryVersion;
    Map<Class<? extends Augmentation<Restconf>>, Augmentation<Restconf>> augmentation = Collections.emptyMap();

    public RestconfBuilder() {
    }

    public RestconfBuilder(Restconf base) {
        Map aug;
        this._data = base.getData();
        this._operations = base.getOperations();
        this._yangLibraryVersion = base.getYangLibraryVersion();
        if (base instanceof RestconfImpl) {
            RestconfImpl impl = (RestconfImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Restconf>>, Augmentation<Restconf>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Restconf>>, Augmentation<Restconf>>(aug);
        }
    }

    public Data getData() {
        return this._data;
    }

    public Operations getOperations() {
        return this._operations;
    }

    public String getYangLibraryVersion() {
        return this._yangLibraryVersion;
    }

    public <E$$ extends Augmentation<Restconf>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public RestconfBuilder setData(Data value) {
        this._data = value;
        return this;
    }

    public RestconfBuilder setOperations(Operations value) {
        this._operations = value;
        return this;
    }

    private static void check_yangLibraryVersionLength(String value) {
    }

    public RestconfBuilder setYangLibraryVersion(String value) {
        if (value != null) {
            RestconfBuilder.check_yangLibraryVersionLength(value);
        }
        this._yangLibraryVersion = value;
        return this;
    }

    public RestconfBuilder addAugmentation(Class<? extends Augmentation<Restconf>> augmentationType, Augmentation<Restconf> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Restconf>>, Augmentation<Restconf>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RestconfBuilder removeAugmentation(Class<? extends Augmentation<Restconf>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Restconf build() {
        return new RestconfImpl(this);
    }

    private static final class RestconfImpl
    implements Restconf {
        private final Data _data;
        private final Operations _operations;
        private final String _yangLibraryVersion;
        private Map<Class<? extends Augmentation<Restconf>>, Augmentation<Restconf>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        RestconfImpl(RestconfBuilder base) {
            this._data = base.getData();
            this._operations = base.getOperations();
            this._yangLibraryVersion = base.getYangLibraryVersion();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Restconf> getImplementedInterface() {
            return Restconf.class;
        }

        @Override
        public Data getData() {
            return this._data;
        }

        @Override
        public Operations getOperations() {
            return this._operations;
        }

        @Override
        public String getYangLibraryVersion() {
            return this._yangLibraryVersion;
        }

        public <E$$ extends Augmentation<Restconf>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._data);
            result = 31 * result + Objects.hashCode(this._operations);
            result = 31 * result + Objects.hashCode(this._yangLibraryVersion);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Restconf.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Restconf other = (Restconf)obj;
            if (!Objects.equals(this._data, other.getData())) {
                return false;
            }
            if (!Objects.equals(this._operations, other.getOperations())) {
                return false;
            }
            if (!Objects.equals(this._yangLibraryVersion, other.getYangLibraryVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RestconfImpl otherImpl = (RestconfImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Restconf>>, Augmentation<Restconf>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Restconf");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_data", (Object)this._data);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_operations", (Object)this._operations);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_yangLibraryVersion", (Object)this._yangLibraryVersion);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

