/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.web;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.ServletContextListener;
import org.immutables.value.Generated;
import org.opendaylight.aaa.web.FilterDetails;
import org.opendaylight.aaa.web.ResourceDetails;
import org.opendaylight.aaa.web.ServletDetails;
import org.opendaylight.aaa.web.WebContext;

@ParametersAreNonnullByDefault
@Generated(from="WebContext", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
public final class WebContextBuilder {
    private static final long INIT_BIT_CONTEXT_PATH = 1L;
    private static final long OPT_BIT_SUPPORTS_SESSIONS = 1L;
    private long initBits = 1L;
    private long optBits;
    @Nullable
    private String contextPath;
    private boolean supportsSessions;
    private List<ServletDetails> servlets = new ArrayList<ServletDetails>();
    private List<FilterDetails> filters = new ArrayList<FilterDetails>();
    private List<ServletContextListener> listeners = new ArrayList<ServletContextListener>();
    private List<ResourceDetails> resources = new ArrayList<ResourceDetails>();
    private Map<String, String> contextParams = new LinkedHashMap<String, String>();

    public final WebContextBuilder from(WebContext instance) {
        Objects.requireNonNull(instance, "instance");
        this.contextPath(instance.contextPath());
        this.supportsSessions(instance.supportsSessions());
        this.addAllServlets(instance.servlets());
        this.addAllFilters(instance.filters());
        this.addAllListeners(instance.listeners());
        this.addAllResources(instance.resources());
        this.putAllContextParams(instance.contextParams());
        return this;
    }

    public final WebContextBuilder contextPath(String contextPath) {
        this.contextPath = Objects.requireNonNull(contextPath, "contextPath");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final WebContextBuilder supportsSessions(boolean supportsSessions) {
        this.supportsSessions = supportsSessions;
        this.optBits |= 1L;
        return this;
    }

    public final WebContextBuilder addServlet(ServletDetails element) {
        this.servlets.add(Objects.requireNonNull(element, "servlets element"));
        return this;
    }

    public final WebContextBuilder addServlets(ServletDetails ... elements) {
        for (ServletDetails element : elements) {
            this.servlets.add(Objects.requireNonNull(element, "servlets element"));
        }
        return this;
    }

    public final WebContextBuilder servlets(Iterable<? extends ServletDetails> elements) {
        this.servlets.clear();
        return this.addAllServlets(elements);
    }

    public final WebContextBuilder addAllServlets(Iterable<? extends ServletDetails> elements) {
        for (ServletDetails servletDetails : elements) {
            this.servlets.add(Objects.requireNonNull(servletDetails, "servlets element"));
        }
        return this;
    }

    public final WebContextBuilder addFilter(FilterDetails element) {
        this.filters.add(Objects.requireNonNull(element, "filters element"));
        return this;
    }

    public final WebContextBuilder addFilters(FilterDetails ... elements) {
        for (FilterDetails element : elements) {
            this.filters.add(Objects.requireNonNull(element, "filters element"));
        }
        return this;
    }

    public final WebContextBuilder filters(Iterable<? extends FilterDetails> elements) {
        this.filters.clear();
        return this.addAllFilters(elements);
    }

    public final WebContextBuilder addAllFilters(Iterable<? extends FilterDetails> elements) {
        for (FilterDetails filterDetails : elements) {
            this.filters.add(Objects.requireNonNull(filterDetails, "filters element"));
        }
        return this;
    }

    public final WebContextBuilder addListener(ServletContextListener element) {
        this.listeners.add(Objects.requireNonNull(element, "listeners element"));
        return this;
    }

    public final WebContextBuilder addListeners(ServletContextListener ... elements) {
        for (ServletContextListener element : elements) {
            this.listeners.add(Objects.requireNonNull(element, "listeners element"));
        }
        return this;
    }

    public final WebContextBuilder listeners(Iterable<? extends ServletContextListener> elements) {
        this.listeners.clear();
        return this.addAllListeners(elements);
    }

    public final WebContextBuilder addAllListeners(Iterable<? extends ServletContextListener> elements) {
        for (ServletContextListener servletContextListener : elements) {
            this.listeners.add(Objects.requireNonNull(servletContextListener, "listeners element"));
        }
        return this;
    }

    public final WebContextBuilder addResource(ResourceDetails element) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
        return this;
    }

    public final WebContextBuilder addResources(ResourceDetails ... elements) {
        for (ResourceDetails element : elements) {
            this.resources.add(Objects.requireNonNull(element, "resources element"));
        }
        return this;
    }

    public final WebContextBuilder resources(Iterable<? extends ResourceDetails> elements) {
        this.resources.clear();
        return this.addAllResources(elements);
    }

    public final WebContextBuilder addAllResources(Iterable<? extends ResourceDetails> elements) {
        for (ResourceDetails resourceDetails : elements) {
            this.resources.add(Objects.requireNonNull(resourceDetails, "resources element"));
        }
        return this;
    }

    public final WebContextBuilder putContextParam(String key, String value) {
        this.contextParams.put(Objects.requireNonNull(key, "contextParams key"), Objects.requireNonNull(value, "contextParams value"));
        return this;
    }

    public final WebContextBuilder putContextParam(Map.Entry<String, ? extends String> entry) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.contextParams.put(Objects.requireNonNull(k, "contextParams key"), Objects.requireNonNull(v, "contextParams value"));
        return this;
    }

    public final WebContextBuilder contextParams(Map<String, ? extends String> entries) {
        this.contextParams.clear();
        return this.putAllContextParams(entries);
    }

    public final WebContextBuilder putAllContextParams(Map<String, ? extends String> entries) {
        for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            this.contextParams.put(Objects.requireNonNull(k, "contextParams key"), Objects.requireNonNull(v, "contextParams value"));
        }
        return this;
    }

    public WebContext build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return ImmutableWebContext.validate(new ImmutableWebContext(this));
    }

    private boolean supportsSessionsIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("contextPath");
        }
        return "Cannot build WebContext, some of required attributes are not set " + attributes;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="WebContext", generator="Immutables")
    @Immutable
    private static final class ImmutableWebContext
    extends WebContext {
        private final String contextPath;
        private final boolean supportsSessions;
        private final List<ServletDetails> servlets;
        private final List<FilterDetails> filters;
        private final List<ServletContextListener> listeners;
        private final List<ResourceDetails> resources;
        private final Map<String, String> contextParams;

        private ImmutableWebContext(WebContextBuilder builder) {
            this.contextPath = builder.contextPath;
            this.servlets = WebContextBuilder.createUnmodifiableList(true, builder.servlets);
            this.filters = WebContextBuilder.createUnmodifiableList(true, builder.filters);
            this.listeners = WebContextBuilder.createUnmodifiableList(true, builder.listeners);
            this.resources = WebContextBuilder.createUnmodifiableList(true, builder.resources);
            this.contextParams = WebContextBuilder.createUnmodifiableMap(false, false, builder.contextParams);
            this.supportsSessions = builder.supportsSessionsIsSet() ? builder.supportsSessions : super.supportsSessions();
        }

        @Override
        public String contextPath() {
            return this.contextPath;
        }

        @Override
        public boolean supportsSessions() {
            return this.supportsSessions;
        }

        @Override
        public List<ServletDetails> servlets() {
            return this.servlets;
        }

        @Override
        public List<FilterDetails> filters() {
            return this.filters;
        }

        @Override
        public List<ServletContextListener> listeners() {
            return this.listeners;
        }

        @Override
        public List<ResourceDetails> resources() {
            return this.resources;
        }

        @Override
        public Map<String, String> contextParams() {
            return this.contextParams;
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableWebContext && this.equalTo((ImmutableWebContext)another);
        }

        private boolean equalTo(ImmutableWebContext another) {
            return this.contextPath.equals(another.contextPath) && this.supportsSessions == another.supportsSessions && this.servlets.equals(another.servlets) && this.filters.equals(another.filters) && this.listeners.equals(another.listeners) && this.resources.equals(another.resources) && this.contextParams.equals(another.contextParams);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.contextPath.hashCode();
            h += (h << 5) + Boolean.hashCode(this.supportsSessions);
            h += (h << 5) + this.servlets.hashCode();
            h += (h << 5) + this.filters.hashCode();
            h += (h << 5) + this.listeners.hashCode();
            h += (h << 5) + this.resources.hashCode();
            h += (h << 5) + this.contextParams.hashCode();
            return h;
        }

        public String toString() {
            return "WebContext{contextPath=" + this.contextPath + ", supportsSessions=" + this.supportsSessions + ", servlets=" + this.servlets + ", filters=" + this.filters + ", listeners=" + this.listeners + ", resources=" + this.resources + ", contextParams=" + this.contextParams + "}";
        }

        private static ImmutableWebContext validate(ImmutableWebContext instance) {
            instance.check();
            return instance;
        }
    }
}

