/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.filterchain.configuration.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.aaa.filterchain.configuration.CustomFilterAdapterConfiguration;
import org.opendaylight.aaa.filterchain.configuration.CustomFilterAdapterListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomFilterAdapterConfigurationImpl
implements CustomFilterAdapterConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CustomFilterAdapterConfigurationImpl.class);
    private static final String FILTER_DTO_SEPARATOR = ",";
    static final String CUSTOM_FILTER_LIST_KEY = "customFilterList";
    private final Collection<CustomFilterAdapterListener> listeners = ConcurrentHashMap.newKeySet();
    private volatile List<FilterDTO> namedFilterDTOs = Collections.emptyList();
    private volatile List<FilterDTO> instanceFilterDTOs = Collections.emptyList();

    public CustomFilterAdapterConfigurationImpl(Map<String, String> properties) {
        this.update(properties);
    }

    public void close() {
    }

    public void update(Map<String, String> properties) {
        if (properties != null) {
            LOG.info("Custom filter properties updated: {}", properties);
            this.namedFilterDTOs = this.getCustomFilterList(properties);
            this.updateListeners();
        }
    }

    public void onFilterAdded(Filter filter, Map<String, String> properties) {
        if (filter == null) {
            return;
        }
        LOG.info("Custom Filter {} added", (Object)filter);
        this.instanceFilterDTOs = ImmutableList.builder().addAll(this.instanceFilterDTOs).add((Object)FilterDTO.createFilterDTO(filter)).build();
        this.updateListeners();
    }

    public void onFilterRemoved(Filter filter, Map<String, String> properties) {
        if (filter == null) {
            return;
        }
        LOG.info("Custom Filter {} removed", (Object)filter);
        FilterDTO toRemove = FilterDTO.createFilterDTO(filter);
        this.instanceFilterDTOs = ImmutableList.copyOf((Collection)this.instanceFilterDTOs.stream().filter(dto -> !dto.equals(toRemove)).collect(Collectors.toList()));
        this.updateListeners();
    }

    private void updateListeners() {
        for (CustomFilterAdapterListener listener : this.listeners) {
            this.updateListener(listener);
        }
    }

    private void updateListener(CustomFilterAdapterListener listener) {
        Optional<ServletContext> listenerServletContext = CustomFilterAdapterConfigurationImpl.extractServletContext(listener);
        List<Filter> filterList = this.convertCustomFilterList(listenerServletContext);
        LOG.debug("Notifying listener {} of filters {}", (Object)listener, filterList);
        listener.updateInjectedFilters(filterList);
    }

    private static Optional<ServletContext> extractServletContext(CustomFilterAdapterListener listener) {
        FilterConfig listenerFilterConfig = listener.getFilterConfig();
        return listenerFilterConfig != null ? Optional.ofNullable(listenerFilterConfig.getServletContext()) : Optional.empty();
    }

    private List<Filter> convertCustomFilterList(Optional<ServletContext> listenerServletContext) {
        List filterList = ImmutableList.builder().addAll(this.namedFilterDTOs).addAll(this.instanceFilterDTOs).build().stream().flatMap(filter -> CustomFilterAdapterConfigurationImpl.getFilterInstance(filter, listenerServletContext)).collect(Collectors.toList());
        return Collections.unmodifiableList(filterList);
    }

    private static Stream<Filter> getFilterInstance(FilterDTO customFilter, Optional<ServletContext> servletContext) {
        Filter filter = customFilter.getInstance(servletContext);
        if (filter != null) {
            LOG.info("Successfully loaded custom Filter {} for context {}", (Object)filter, servletContext);
            return Stream.of(filter);
        }
        return Stream.empty();
    }

    private List<FilterDTO> getCustomFilterList(Map<String, String> configuration) {
        String customFilterListValue = configuration.get(CUSTOM_FILTER_LIST_KEY);
        ImmutableList.Builder customFilterListBuilder = ImmutableList.builder();
        if (customFilterListValue != null) {
            List<String> filterClazzNames = Arrays.asList(customFilterListValue.replaceAll("\\s", "").split(FILTER_DTO_SEPARATOR));
            for (String filterClazzName : filterClazzNames) {
                if (Strings.isNullOrEmpty((String)filterClazzName)) continue;
                Map<String, String> applicableConfigs = CustomFilterAdapterConfigurationImpl.extractPropertiesForFilter(filterClazzName, configuration);
                FilterDTO filterDTO = FilterDTO.createFilterDTO(filterClazzName, applicableConfigs);
                customFilterListBuilder.add((Object)filterDTO);
            }
        }
        return customFilterListBuilder.build();
    }

    private static Map<String, String> extractPropertiesForFilter(String clazzName, Map<String, String> fullConfiguration) {
        HashMap<String, String> extractedConfig = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : fullConfiguration.entrySet()) {
            String key = entry.getKey();
            int lastDotSeparator = key.lastIndexOf(".");
            if (lastDotSeparator >= 0) {
                String comparisonClazzNameSubstring = key.substring(0, lastDotSeparator);
                if (!comparisonClazzNameSubstring.equals(clazzName)) continue;
                String filterInitParamKey = key.substring(lastDotSeparator + 1);
                extractedConfig.put(filterInitParamKey, entry.getValue());
                continue;
            }
            if (key.equals(CUSTOM_FILTER_LIST_KEY)) continue;
            LOG.error("couldn't parse property \"{}\"; skipping", (Object)key);
        }
        return extractedConfig;
    }

    @Override
    public void registerCustomFilterAdapterConfigurationListener(CustomFilterAdapterListener listener) {
        LOG.debug("registerCustomFilterAdapterConfigurationListener: {}", (Object)listener);
        if (this.listeners.add(listener)) {
            LOG.debug("Updated listener set: {}", this.listeners);
            this.updateListener(listener);
        }
    }

    private static class InstanceFilterDTO
    extends FilterDTO {
        private final Filter instance;

        InstanceFilterDTO(Filter instance) {
            super(Collections.emptyMap());
            this.instance = Objects.requireNonNull(instance);
        }

        @Override
        Filter getInstance(Optional<ServletContext> servletContext) {
            return this.instance;
        }

        public int hashCode() {
            return this.instance.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstanceFilterDTO other = (InstanceFilterDTO)obj;
            return this.instance.equals(other.instance);
        }

        public String toString() {
            return "InstanceFilterDTO [instance=" + this.instance + "]";
        }
    }

    private static class NamedFilterDTO
    extends FilterDTO {
        private final String clazzName;

        NamedFilterDTO(String clazzName, Map<String, String> initParams) {
            super(initParams);
            this.clazzName = Objects.requireNonNull(clazzName);
        }

        @Override
        Filter getInstance(Optional<ServletContext> servletContext) {
            try {
                Class<?> filterClazz = Class.forName(this.clazzName);
                return this.init((Filter)filterClazz.newInstance(), servletContext);
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOG.error("Error loading  {}", (Object)this, (Object)e);
                return null;
            }
        }

        private Filter init(Filter filter, Optional<ServletContext> servletContext) {
            try {
                InjectedFilterConfig filterConfig = InjectedFilterConfig.createInjectedFilterConfig(filter, servletContext, this.getInitParams());
                filter.init((FilterConfig)filterConfig);
            }
            catch (ServletException e) {
                LOG.error("Error injecting custom filter {} - continuing anyway", (Object)filter, (Object)e);
            }
            return filter;
        }

        public int hashCode() {
            return this.clazzName.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NamedFilterDTO other = (NamedFilterDTO)obj;
            return this.clazzName.equals(other.clazzName);
        }

        public String toString() {
            return "NamedFilterDTO [clazzName=" + this.clazzName + ", initParams=" + this.getInitParams() + "]";
        }
    }

    private static abstract class FilterDTO {
        private final Map<String, String> initParams;

        protected FilterDTO(Map<String, String> initParams) {
            this.initParams = Objects.requireNonNull(initParams);
        }

        abstract @Nullable Filter getInstance(Optional<ServletContext> var1);

        static FilterDTO createFilterDTO(String clazzName, Map<String, String> initParams) {
            return new NamedFilterDTO(clazzName, initParams);
        }

        static FilterDTO createFilterDTO(Filter instance) {
            return new InstanceFilterDTO(instance);
        }

        Map<String, String> getInitParams() {
            return this.initParams;
        }
    }

    private static final class InjectedFilterConfig
    implements FilterConfig {
        private final String filterName;
        private final ServletContext servletContext;
        private final Map<String, String> filterConfig;

        private InjectedFilterConfig(Filter filter, Optional<ServletContext> servletContext, Map<String, String> filterConfig) {
            this.filterName = filter.getClass().getSimpleName();
            this.servletContext = servletContext.orElse(null);
            this.filterConfig = filterConfig;
        }

        static InjectedFilterConfig createInjectedFilterConfig(Filter filter, Optional<ServletContext> servletContext, Map<String, String> filterConfig) {
            return new InjectedFilterConfig(filter, servletContext, filterConfig);
        }

        public String getFilterName() {
            return this.filterName;
        }

        public String getInitParameter(String paramName) {
            return this.filterConfig != null ? this.filterConfig.get(paramName) : null;
        }

        public Enumeration<String> getInitParameterNames() {
            return this.filterConfig != null ? new Enumeration<String>(){
                final Iterator<String> keySet;
                {
                    this.keySet = filterConfig.keySet().iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.keySet.hasNext();
                }

                @Override
                public String nextElement() {
                    return this.keySet.next();
                }
            } : Collections.emptyEnumeration();
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }
    }
}

