/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.concepts.AbstractMessageProxy;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

@Beta
public abstract class Message<T extends WritableIdentifier, C extends Message<T, C>>
implements Immutable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final @NonNull ABIVersion version;
    private final long sequence;
    private final @NonNull T target;

    private Message(ABIVersion version, T target, long sequence) {
        this.target = (WritableIdentifier)Objects.requireNonNull(target);
        this.version = Objects.requireNonNull(version);
        this.sequence = sequence;
    }

    Message(T target, long sequence) {
        this(ABIVersion.current(), target, sequence);
    }

    Message(C msg, ABIVersion version) {
        this(version, ((Message)msg).getTarget(), ((Message)msg).getSequence());
    }

    public final @NonNull T getTarget() {
        return this.target;
    }

    public final long getSequence() {
        return this.sequence;
    }

    @VisibleForTesting
    public final @NonNull ABIVersion getVersion() {
        return this.version;
    }

    public final @NonNull C toVersion(@NonNull ABIVersion toVersion) {
        if (this.version == toVersion) {
            return (C)this;
        }
        switch (toVersion) {
            case BORON: {
                return (C)((Message)Verify.verifyNotNull(this.cloneAsVersion(toVersion)));
            }
        }
        throw new IllegalArgumentException("Unhandled ABI version " + (Object)((Object)toVersion));
    }

    protected abstract @NonNull C cloneAsVersion(@NonNull ABIVersion var1);

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MoreObjects.ToStringHelper addToStringAttributes(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("target", this.target).add("sequence", (Object)Long.toUnsignedString(this.sequence));
    }

    abstract @NonNull AbstractMessageProxy<T, C> externalizableProxy(@NonNull ABIVersion var1);

    protected final Object writeReplace() {
        return this.externalizableProxy(this.version);
    }
}

