/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.opendaylight.controller.cluster.access.commands.TransactionDelete;
import org.opendaylight.controller.cluster.access.commands.TransactionMerge;
import org.opendaylight.controller.cluster.access.commands.TransactionWrite;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataInput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@Beta
public abstract class TransactionModification {
    static final byte TYPE_DELETE = 1;
    static final byte TYPE_MERGE = 2;
    static final byte TYPE_WRITE = 3;
    private final YangInstanceIdentifier path;

    TransactionModification(YangInstanceIdentifier path) {
        this.path = (YangInstanceIdentifier)Preconditions.checkNotNull((Object)path);
    }

    public final YangInstanceIdentifier getPath() {
        return this.path;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).toString();
    }

    abstract byte getType();

    void writeTo(NormalizedNodeDataOutput out) throws IOException {
        out.writeByte((int)this.getType());
        out.writeYangInstanceIdentifier(this.path);
    }

    static TransactionModification readFrom(NormalizedNodeDataInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 1: {
                return new TransactionDelete(in.readYangInstanceIdentifier());
            }
            case 2: {
                return new TransactionMerge(in.readYangInstanceIdentifier(), in.readNormalizedNode());
            }
            case 3: {
                return new TransactionWrite(in.readYangInstanceIdentifier(), in.readNormalizedNode());
            }
        }
        throw new IllegalArgumentException("Unhandled type " + type);
    }
}

